/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $inst1.P */

/* **********************************************************************
$inst1_export([$varinst/8,$coninst/5,$strinst/4,$varsubinst/7,$consubinst/3]).

$inst1_use($computil1,[_,_,_,$getreg/2,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]).
********************************************************************** */


:- mode($varinst,8,[c,c,c,c,c,d,d,d]).

$varinst(h,Occ,Typ,Loc,N,Pil,Pilr,Tin) :-
	$inst_varinst_h(_,Occ,Typ,Loc,N,Pil,Pilr,Tin).
$varinst(b,Occ,Typ,Loc,N,Pil,Pilr,Tin) :-
	$inst_varinst_b(_,Occ,Typ,Loc,N,Pil,Pilr,Tin).

:- mode($inst_varinst_h,8,[d,c,c,c,c,d,d,d]).
:- index($inst_varinst_h, 8, 2).

$inst_varinst_h(X,f,Typ,Loc,N,Pil,Pilr,Tin) :-
	$inst_varinst_hf(X,_,Typ,Loc,N,Pil,Pilr,Tin).
$inst_varinst_h(X,s,Typ,Loc,N,Pil,Pilr,Tin) :-
	$inst_varinst_hs(X,_,Typ,Loc,N,Pil,Pilr,Tin).

:- mode($inst_varinst_hf,8,[d,d,c,c,c,d,d,d]).
:- index($inst_varinst_hf, 8, 3).

$inst_varinst_hf(_,_,p,Loc,N,[getpvar(Loc,N)|Pil],Pil,_).
$inst_varinst_hf(_,_,d,Loc,N,[getpvar(Loc,N)|Pil],Pil,_).
$inst_varinst_hf(_,_,t,Loc,N,Pil,Pilr,_) :-
	((Loc =:= N, Pil = Pilr) ;
	 (Loc =\= N, Pil = [movreg(N,Loc)|Pilr])
	).

:- mode($inst_varinst_hs,8,[d,d,c,c,c,d,d,d]).
:- index($inst_varinst_hs, 8, 3).

$inst_varinst_hs(_,_,p,Loc,N,[getpval(Loc,N)|Pil],Pil,_).
$inst_varinst_hs(_,_,d,Loc,N,[getpval(Loc,N)|Pil],Pil,_).
$inst_varinst_hs(_,_,t,Loc,N,[gettval(Loc,N)|Pil],Pil,_).
$inst_varinst_hs(_,_,u,Loc,N,[putuval(Loc,N1),gettval(N1,N)|Pil],Pil,T) :-
	$getreg(T,N1), N1 =\= N.

:- mode($inst_varinst_b,8,[d,c,c,c,c,d,d,d]).
:- index($inst_varinst_b, 8, 2).

$inst_varinst_b(X,f,Typ,Loc,N,Pil,Pilr,Tin) :-
	$inst_varinst_bf(X,_,Typ,Loc,N,Pil,Pilr,Tin).
$inst_varinst_b(X,s,Typ,Loc,N,Pil,Pilr,Tin) :-
	$inst_varinst_bs(X,_,Typ,Loc,N,Pil,Pilr,Tin).

:- mode($inst_varinst_bf,8,[d,d,c,c,c,d,d,d]).
:- index($inst_varinst_bf, 8, 3).

$inst_varinst_bf(_,_,p,Loc,N,[putpvar(Loc,N)|Pil],Pil,_).
$inst_varinst_bf(_,_,t,Loc,N,[puttvar(Loc,N)|Pil],Pil,_).

:- mode($inst_varinst_bs,8,[d,d,c,c,c,d,d,d]).
:- index($inst_varinst_bs, 8, 3).

$inst_varinst_bs(_,_,t,Loc,N,Pil,Pilr,_) :-
	((Loc =:= N, Pil = Pilr) ;
	 (Loc =\= N, Pil = [movreg(Loc,N)|Pilr])
	).
$inst_varinst_bs(_,_,p,Loc,N,[putpval(Loc,N)|Pil],Pil,_).
$inst_varinst_bs(_,_,u,Loc,N,[putuval(Loc,N)|Pil],Pil,_).
$inst_varinst_bs(_,_,d,Loc,N,[putdval(Loc,N)|Pil],Pil,_).

:- mode($coninst,5,[c,c,c,d,d]).

$coninst(h,Const,N,[Inst|Pilr],Pilr) :-
	integer(Const) -> Inst = getnumcon(Const,N) ;
	real(Const)    -> Inst = getfloatcon(Const,N) ;
	Const ?= '[]'  -> Inst = getnil(N) ;
		          Inst = getcon(Const,N).
$coninst(b,Const,N,[Inst|Pilr],Pilr) :-
	integer(Const) -> Inst = putnumcon(Const,N) ;
	real(Const)    -> Inst = putfloatcon(Const,N) ;
	Const ?= '[]'  -> Inst = putnil(N) ;
		          Inst = putcon(Const,N).

:- mode($strinst,4,[c,c,c,d]).

$strinst(h,Str,N,Inst) :-
     Str ?= ('.',2) -> Inst = getlist(N) ;
     Str ?= (',',2) -> Inst = getcomma(N) ;
	               Inst = getstr(Str,N).
$strinst(b,Str,N,Inst) :-
     Str ?= ('.',2) -> Inst = putlist(N) ;
	               Inst = putstr(Str,N).

:- mode($varsubinst,7,[c,c,c,c,d,d,d]).

$varsubinst(h,Occ,Typ,Loc,Pil,Pilr,Tin) :-
	$inst_varsubinst_h(_,Occ,Typ,Loc,Pil,Pilr,Tin).
$varsubinst(b,Occ,Typ,Loc,Pil,Pilr,Tin) :-
	$inst_varsubinst_b(_,Occ,Typ,Loc,Pil,Pilr,Tin).

:- mode($inst_varsubinst_h,7,[d,c,c,c,d,d,d]).
:- index($inst_varsubinst_h,7,2).

$inst_varsubinst_h(X,f,Typ,Loc,Pil,Pilr,Tin) :-
	$inst_varsubinst_hf(X,_,Typ,Loc,Pil,Pilr,Tin).
$inst_varsubinst_h(X,s,Typ,Loc,Pil,Pilr,Tin) :-
	$inst_varsubinst_hs(X,_,Typ,Loc,Pil,Pilr,Tin).

:- mode($inst_varsubinst_b,7,[d,c,c,c,d,d,d]).
:- index($inst_varsubinst_b,7,2).

$inst_varsubinst_b(X,f,Typ,Loc,Pil,Pilr,Tin) :-
	$inst_varsubinst_bf(X,_,Typ,Loc,Pil,Pilr,Tin).
$inst_varsubinst_b(X,s,Typ,Loc,Pil,Pilr,Tin) :-
	$inst_varsubinst_bs(X,_,Typ,Loc,Pil,Pilr,Tin).

:- mode($inst_varsubinst_hf,7,[d,d,c,c,d,d,d]).
:- index($inst_varsubinst_hf,7,3).

$inst_varsubinst_hf(_,_,p,Loc,[unipvar(Loc)|Pilr],Pilr,_).
$inst_varsubinst_hf(_,_,t,Loc,[unitvar(Loc)|Pilr],Pilr,_).

:- mode($inst_varsubinst_hs,7,[d,d,c,c,d,d,d]).
:- index($inst_varsubinst_hs,7,3).

$inst_varsubinst_hs(_,_,p,Loc,[unipval(Loc)|Pilr],Pilr,_).
$inst_varsubinst_hs(_,_,d,Loc,[unipval(Loc)|Pilr],Pilr,_).
$inst_varsubinst_hs(_,_,t,Loc,[unitval(Loc)|Pilr],Pilr,_).
$inst_varsubinst_hs(_,_,u,Loc,[putuval(Loc,N),unitval(N)|Pilr],Pilr,T) :-
	$getreg(T,N).

:- mode($inst_varsubinst_bf,7,[d,d,c,c,d,d,d]).
:- index($inst_varsubinst_bf,7,3).

$inst_varsubinst_bf(_,_,p,Loc,[bldpvar(Loc)|Pilr],Pilr,_).
$inst_varsubinst_bf(_,_,t,Loc,[bldtvar(Loc)|Pilr],Pilr,_).

:- mode($inst_varsubinst_bs,7,[d,d,c,c,d,d,d]).
:- index($inst_varsubinst_bs,7,3).

$inst_varsubinst_bs(_,_,p,Loc,[bldpval(Loc)|Pilr],Pilr,_).
$inst_varsubinst_bs(_,_,d,Loc,[bldpval(Loc)|Pilr],Pilr,_).
$inst_varsubinst_bs(_,_,u,Loc,[bldpval(Loc)|Pilr],Pilr,_).
$inst_varsubinst_bs(_,_,t,Loc,[bldtval(Loc)|Pilr],Pilr,_).

:- mode($consubinst,3,[c,c,d]).

$consubinst(h,Const,Inst) :-
	integer(Const) -> Inst = uninumcon(Const) ;
	real(Const)    -> Inst = unifloatcon(Const) ;
	Const ?= '[]'   -> Inst = uninil ;
			  Inst = unicon(Const).
$consubinst(b,Const,Inst) :-
	integer(Const) -> Inst = bldnumcon(Const) ;
	real(Const)    -> Inst = bldfloatcon(Const) ;
	Const ?= '[]'   -> Inst = bldnil ;
			  Inst = bldcon(Const).

/* ----------------------------- end inst1.P ----------------------------- */

