/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $index1.P */

/*   "index" generates code for indexing into the head of a set of clauses
      for a predicate.							*/

/* **********************************************************************
$index1_export([$index/8]).

$index1_use($glob,[_,$gennum/1,_]).
$index1_use($blist,[_,$member/2,$member1/2]).
$index1_use($meta,[_,_,$length/2]).
$index1_use($listutil1,[_,_,_,_,$nthmember/3,_,_,_]).
$index1_use($bmeta,[_,_,_,$number/1,_,_,_,_,_]).
********************************************************************** */

/* argument 8 of $index is 1 if a switchonlist instruction was generated
   (in which case special code must be generated for the clauses), 0 o/w */

$index(Pred,0,Clauses,_,Pil,Pilr,Prag,0) :-
	$index_noarg_chain(Clauses,Chain),
	$gennum(N),
	$index_gen0(0,Chain,(Pred,0,N),Pil,Pilr).
$index(P,Arity,Clauses,PPrag,[label((P,Arity,N))|Pil],Pilr,Prag,SwList) :-
	$gennum(N),
	($member1(index(Narg),Prag) ; Narg = 1),
	$index1(Clauses,Narg,ArgList),
	$length(ArgList, NumClauses),
	((ArgList = [argt(T1,_,L1),argt(T2,_,L2)],
	  $index_sot_inst(T1,T2,Narg,L1,L2,Inst,SwList),
	  Pil = [Inst|Pil2],
	  T = 1
	 );
	 (SwList = 0,
	  $index_yn(P,Arity,ArgList,Prag,T),
	  ((T =:= 1, Pil = [pred((P, Arity, N), NumClauses)|Pil1],
	    $index_gen_tab(ArgList, P, Pil1, Pil3),
	    Pil3 = [switchonbound(Narg, N, N)|Pil2]
	   );
	   (T =\= 1, Pil2 = Pil)
	  )
	 )
	),
	((T =:= 1, 					  /* index created */
	  symtype('_$mode'(_,_,_),ModeDef), ModeDef > 0,
	  '_$mode'(P,Arity,Mode),
	  $nthmember(BoundArg,Mode,Narg),
	  BoundArg > 0					  /* indexed arg is bound */
	 ) ->
	      Pil2 = Pilr ;
	      ($index_noarg_chain(Clauses, Chain),
	       $index_gen0(Arity, Chain, _, Pil2, Pilr)
	      )
	).

$index_yn(P,Arity,ArgList,Prag,T) :- 
	($member(index(_),Prag) ; $member(index,Prag)),
	$index_yn1(ArgList,1,T).
$index_yn(P, Arity,_,_,0).

$index_yn1([], T, T).
$index_yn1([argt(v,_,_)|Rest],_,0).
$index_yn1([_|Rest], T2, T) :-  $index_yn1(Rest, T2, T).

$index_gen_tab([], _, Pil, Pil).
$index_gen_tab([argt(T, Arg, (_, Arity, N))|Rest], P, 
		[arglabel(T, Arg, (P, Arity, N))|Pil], Pilr) :-
	$index_gen_tab(Rest, P, Pil, Pilr).


$index1([],_,[]).
$index1([clause(Arglist,_,P)|CRest], N, [argt(Type,NewArg,L)|AtypeRest]) :-
        $nthmember(Arg, Arglist, N),
	$member1(label(L),P),
	$index_getargtype(Arg,argt(Type, NewArg, L)),
	$index1(CRest,N,AtypeRest).

$index_getargtype([[]], argt(n, [], _)).
$index_getargtype([X], argt(i, X, _)) :- $number(X).
$index_getargtype([C], argt(c,C,_)).
$index_getargtype(v(_,_),argt(v,v,_)).
$index_getargtype([.|A], argt(l,l,_)).
$index_getargtype([S|A],argt(s,(S, Ar),_)) :- $length(A, Ar), Ar =\= 0.


$index_noarg_chain([],[]).
$index_noarg_chain([clause(_,_,Prag)|ClRest],[lab(Label)|LRest]) :-
	$member1(label(Label),Prag),
	$index_noarg_chain(ClRest,LRest).

:- index($index_gen0, 5, 2).

$index_gen0(_,[],abs(-1),Pil,Pil).
$index_gen0(_,[lab(Label)],Label,Pil,Pil) :-
	(var(Label), Label = (sot_label, -1, N), $gennum(N)) ; nonvar(Label).
$index_gen0(Arity,[lab(Label)|Rest],L,[label(L),try(Label,Arity)|Pil],Pilr) :-
	Rest = [_|_],
	((var(L), L = (sot_label, -1, N), $gennum(N)) ; nonvar(L)),
	$index_gen1(Arity,Rest,Pil,Pilr).

$index_gen1(Arity,[lab(L1)],[trust(L1,Arity)|Pilr],Pilr).

$index_gen1(Arity,[lab(L1)|Rest],[retry(L1,Arity)|Pil],Pilr) :-
	Rest = [_|_],
	$index_gen1(Arity,Rest,Pil,Pilr).

$index_sot_inst(i,l,N,L1,L2,switchonterm(N,L1,L2),0).
$index_sot_inst(i,s,N,L1,L2,switchonterm(N,L1,L2),0).
$index_sot_inst(n,l,N,L1,L2,Inst,SwList) :-
     N =:= 1 ->
          (L1 = (P,K,L1a), L2 = (_,_,L2a),
	   Inst = switchonlist(N,(P,K,L1nil),(P,K,L2lis)),
	   SwList = 1,
           $concat_atom(L1a,nil,L1nil),
           $concat_atom(L2a,lis,L2lis)
	  ) ;
	  (Inst = switchonterm(N,L1,L2), SwList = 0).
$index_sot_inst(n,s,N,L1,L2,switchonterm(N,L1,L2),0).
$index_sot_inst(c,l,N,L1,L2,switchonterm(N,L1,L2),0).
$index_sot_inst(c,s,N,L1,L2,switchonterm(N,L1,L2),0).
$index_sot_inst(l,i,N,L1,L2,switchonterm(N,L2,L1),0).
$index_sot_inst(s,i,N,L1,L2,switchonterm(N,L2,L1),0).
$index_sot_inst(l,n,N,L1,L2,Inst,SwList) :-
     N =:= 1 ->
          (L1 = (P,K,L1a), L2 = (_,_,L2a),
	   Inst = switchonlist(N,(P,K,L2nil),(P,K,L1lis)),
	   SwList = 1,
           $concat_atom(L2a,nil,L2nil),
           $concat_atom(L1a,lis,L1lis)
	  ) ;
	  (Inst = switchonterm(N,L2,L1), SwList = 0).
$index_sot_inst(s,n,N,L1,L2,switchonterm(N,L2,L1),0).
$index_sot_inst(l,c,N,L1,L2,switchonterm(N,L2,L1),0).
$index_sot_inst(s,c,N,L1,L2,switchonterm(N,L2,L1),0).

/* ------------------------------ $index1.P ------------------------------ */

