/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $convrhs1.P */

/* **********************************************************************
$convrhs1_export([$convrhs/12]).

$convrhs1_use($meta,[_,$univ/2,$length/2]).
$convrhs_use($aux1,[_,_,_,_,_,_,_,_,$logical_or/3]).
$convrhs_use($computil1,[_,_,_,_,$max/3,_,_,_,_,$length1/2,
				$prefix_list/3,_,_,_,_,_,_,_,_,_]).
$convrhs1_use($inline1,[$inline/2]).
$convrhs1_use($blist,[_,_,$member1/2]).
$convrhs1_use($getclauses,[_,_,$attach/2]).
$convrhs1_use($targlist1,[_,$targlist/10,$targ_is/8]).
********************************************************************** */


/*  The last 3 parameters of convrhs are as follows: NFlag is set to 1
    if there is need for normalization in the clause, i.e. when execution
    paths fork.  AFlag is set to 1 if it is clear that an "allocate" instr
    must be generated, e.g. when a disjunction is present.  LFlag is 1 if
    the subtree convrhs is processing contains a last literal of the clause,
    0 if it does not (this is necessary to be able to handle variables
    which occur only in the last literals of the clause, in different
    disjunctive branches -- we have to be able to recognize them as temps.  */

$convrhs((Goal,Goals),and(Rgoal,_,Rgoals),VidTbl,
		Pathin,Pathout,St,Litin,Litout,BindList,NFlag,AFlag,LFlag) :-
	!,
    $convrhs(Goal,Rgoal,VidTbl,
		Pathin,Pathmid,St,Litin,Litmid,BindList,NFlag0,AFlag0,0),
    $convrhs(Goals,Rgoals,VidTbl,
		Pathmid,Pathout,St,Litmid,Litout,BindList,NFlag1,AFlag1,LFlag),
    $logical_or(NFlag0,NFlag1,NFlag),
    $logical_or(AFlag0,AFlag1,AFlag).

$convrhs(';'(Goal,Goals),or(Rgoal,_,Rgoals),VidTbl,
			Pathin,Pathout,St,Litin,Litout,BindList,1,1,LFlag) :-
	!,
    $length1(BindList,BLen),
    $convrhs(Goal,Rgoal,VidTbl,
    			Pathin,Pathmid,St,Litin,Litout1,BindList,_,_,LFlag),
    Pathmid1 is Pathmid + 1, $prefix_list(BindList,BLen,BindList1),
    $convrhs(Goals,Rgoals,VidTbl,
    		Pathmid1,Pathout,St,Litin,Litout2,BindList1,_,_,LFlag),
    $max(Litout1, Litout2, Litout).

$convrhs(if_then_else(Test,Goal1,Goal2),if_then_else(RTest,_,RGoal1,RGoal2),
	    VidTbl,Pin,Pout,St,Lin,Lout,BList,1,AFlag,LFlag) :-
	!,
	$convrhs_test(Test,RTest,VidTbl,Pin,St,Lin,Lmid0,BList),
	$length1(BList,BLen),
	$convrhs(Goal1,RGoal1,VidTbl,
			Pin,Pmid1,St,Lmid0,Lout1,BList,_,AFlag1,LFlag),
	$prefix_list(BList,BLen,BList1),
	$convrhs(Goal2,RGoal2,VidTbl,
			Pmid1,Pout,St,Lmid0,Lout2,BList1,_,AFlag2,LFlag),
	$max(Lout1,Lout2,Lout),
	$logical_or(AFlag1,AFlag2,AFlag).
$convrhs(Goal,Rgoal,VidTbl,Pathno,Pathno,St,Litin,Litout,BindList,0,0,LFlag) :-
    $convrhs_nextlitno(Goal,Litin,Litout),
    $convgoal(Goal,Rgoal,Pathno,VidTbl,St,Litin,BindList,LFlag).

/*  	"convrhs_test" converts the test for an if-then-else		*/

$convrhs_test(','(T1,T2),and(RT1,_,RT2),VidTbl,Pathno,St,Lin,Lout,BList) :-
	!,
	$convrhs_test(T1,RT1,VidTbl,Pathno,St,Lin,Lmid0,BList),
	$convrhs_test(T2,RT2,VidTbl,Pathno,St,Lmid0,Lout,BList).
$convrhs_test(';'(T1,T2),or(RT1,_,RT2),VidTbl,Pathno,St,Lin,Lout,BList) :-
	!,
	$convrhs_test(T1,RT1,VidTbl,Pathno,St,Lin,Lout0,BList),
	$convrhs_test(T2,RT2,VidTbl,Pathno,St,Lin,Lout1,BList),
	$max(Lout0,Lout1,Lout).
$convrhs_test(T,RT,VidTbl,Pathno,St,Lin,Lout,BList) :-
	$convrhs_nextlitno(T,Lin,Lout),
	$convgoal(T,RT,Pathno,VidTbl,St,Lin,BList,0).

$convrhs_nextlitno(Goal, Litnum, NextLitnum) :-
	$univ(Goal,[Pred|Args]),
	$length(Args, Arity),
	(($inline(Pred, Arity), NextLitnum  is Litnum) ;
	 NextLitnum is Litnum + 1).	

$convgoal(Goal,TGoal,Pathno,VidTbl,St,Litno,BindList,LFlag) :-
    St = st(Clist,Vlist),
    $member1(nv(NVars),P), $member1(nv(NVars),P1),
    $attach(c(Litno,Npars,P1),Clist),
    (Goal = is(Lhs,Exp0) ->
	(TGoal = '_call'(is,[A1,A2],P),
	 (var(Exp0) ->
	    Exp1 = Exp0+0 ;		/* to handle "X is Y " */
	    Exp1 = Exp0
	 ),
	 Npars = 2,
	 $member1(inline,P1),
	 $targ_is(Lhs,A1,VidTbl,Vlist,Pathno,Litno,1,LFlag),
	 $targ_is(Exp1,A2,VidTbl,Vlist,Pathno,Litno,2,LFlag)
	) ;
	(functor(Goal,Pred,Npars),
	 ($inline(Pred,Npars) -> $member1(inline,P1) ; true),
	 $targlist(Goal,Npars,Args,VidTbl,Vlist,Pathno,Litno,1,UniList,BindList,LFlag),
	 N1 is Npars+1, 
	 $constr_goal(UniList,Pred,Args,P,N1,Pathno,Litno,NVars,Vlist,TGoal)
	)
    ).

$constr_goal([],Pred,Args,P,_,_,_,NVars,_,'_call'(Pred,Args,P)) :-
	$member1(nv(NVars),P).
$constr_goal([(V=Str)|UniRest],Pred,Args,P,N,Path,L,NVars,Vlist,
			and('_call'(=, [V, Str], NV), _, TGoal1)) :-
	V = v(Vid,Prag), Prag = vrec(_,_,_,_),
	$member1(v(Vid,Occlist),Vlist),
	gennum(Vno), $member1(o(Vno,Path,L,N,t,Prag),Occlist),
	N1 is N+1, $member1(nv(NVars),NV),
	$constr_goal(UniRest,Pred,Args,P,N1,Path,L,NVars,Vlist,TGoal1).

/* ---------------------------- $convrhs1.P --------------------------- */
