/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $asmpass21.P */

/* **********************************************************************
$asmpass21_export([$asm_syminst/4,$asm_lookup0/3,$asm_lookup/3]).

$asmpass21_use($aux1,[_,_,_,_,$umsg/1,_,_,_,_]).
$asmpass21_use($listutil1,[_,_,_,_,_,$nthmember1/3,_,_]).
********************************************************************** */

/*	pass2 takes as input a program containing symbolic labels, 
structure symbols and constants and the symbol tables and returns
a program in which all symbols have been replaced by their byte
code offsets of PSC indices. Also, for "internal" predicates, i.e.
those which are not exported, static linking is carried out as far as
possible.								*/

:- mode($asm_syminst,4,[c,d,d,d]).

$asm_syminst(getcon(Con,R), getcon(I,R), Csym, Lsym) :-
	$asm_lookup((Con, 0, _), Csym, I). 
$asm_syminst(getstr((Str,Arity), R),getstr(I,R),Csym, Lsym) :-
	$asm_lookup((Str,Arity,_), Csym, I).
$asm_syminst(getstrv((Str,Arity), R),getstrv(I,R),Csym, Lsym) :-
	$asm_lookup((Str,Arity,_), Csym, I).
$asm_syminst(unicon(Con), unicon(I), Csym, Lsym) :-
	$asm_lookup((Con,0,_), Csym, I).
$asm_syminst(putcon(Con,R), putcon(I,R), Csym, Lsym) :-
	$asm_lookup((Con,0,_),  Csym, I).
$asm_syminst(putstr((Str,Arity), R),putstr(I,R),Csym, Lsym) :-
	$asm_lookup((Str,Arity,_), Csym, I).
$asm_syminst(putstrv((Str,Arity), R),putstrv(I,R),Csym, Lsym):-
	$asm_lookup((Str,Arity,_), Csym, I).
$asm_syminst(bldcon(Con),bldcon(I),Csym, Lsym) :- 
	$asm_lookup((Con,0,_), Csym, I).
$asm_syminst(call(Pname, Arity, B), call(I,Arity,B), Csym, Lsym) :-
	$asm_lookup((Pname, Arity, _), Csym, I).
$asm_syminst(execute((Pname, Arity)), execute(I), Csym, Lsym) :-
	$asm_lookup((Pname, Arity, _), Csym, I).

$asm_syminst(trymeelse(L, A), trymeelse(Val,A), Csym, Lsym) :-
	$asm_lookup((L, Val), Lsym, _).
$asm_syminst(retrymeelse(L, A), retrymeelse(Val,A), Csym, Lsym) :-
	$asm_lookup((L, Val), Lsym, _).
$asm_syminst(try(L, A), try(Val,A), Csym, Lsym) :-
	$asm_lookup((L, Val), Lsym, _).
$asm_syminst(retry(L, A), retry(Val,A), Csym, Lsym) :-
	$asm_lookup((L, Val), Lsym, _).
$asm_syminst(trust(L, A), trust(Val,A), Csym, Lsym) :-
	$asm_lookup((L, Val), Lsym, _).
$asm_syminst(jump(L), jump(Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(jumpz(R, L), jumpz(R,Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(jumpnz(R, L), jumpnz(R,Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(jumplt(R, L), jumplt(R,Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(jumple(R, L), jumple(R,Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(jumpgt(R, L), jumpgt(R,Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(jumpge(R, L), jumpge(R,Val), Csym, Lsym) :-
	$asm_lookup((L, Val),Lsym,_).
$asm_syminst(switchonterm(R, L1, L2), switchonterm(R,Val1,Val2), Csym, Lsym) :-
	$asm_lookup((L1, Val1), Lsym, _),
	$asm_lookup((L2, Val2), Lsym, _).
$asm_syminst(switchonlist(R, L1, L2), switchonlist(R,Val1,Val2), Csym, Lsym) :-
	$asm_lookup((L1, Val1), Lsym, _),
	$asm_lookup((L2, Val2), Lsym, _).
$asm_syminst(Inst,Inst,_,_).


/*  "$asm_lookup0" is the same as "$asm_lookup", except that it doesn't give
     an error  message if $asm_lookup fails, but simply fails quietly.	*/

$asm_lookup0( ( abs(Value), Value ), _, _).
$asm_lookup0( Symbol, Symtab, Index ) :- 
	$nthmember1( Symbol, Symtab, Index).

$asm_lookup(Symbol,Symtab,Index) :- $asm_lookup0(Symbol,Symtab,Index).
$asm_lookup(Symbol, _, _) :-
	$tell(user),
	$writename('error on lookup in pass2: '),
	$write(Symbol),
	$writename('... aborting execution'),
	$nl,
	abort.

/* end asmpass21.P ***************************************************/
