/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $asmpass11.P */

/* **********************************************************************
$asmpass11_export([$asm_pass1/6]).

$asmpass11_use($blist,[_,_,$member1/2]).
$asmpass11_use($name,[$name/2,_]).
$asmpass11_use($meta,[_,_,$length/2]).
$asmpass11_use($listutil1,[_,_,_,_,_,_,$member2/2,$closetail/1]).
********************************************************************** */

$asm_pass1(AsmInsts, Index, Csym, Lsym, Ntext, Npsc) :-
	$asm_pass1(AsmInsts,Lsym,Csym,0,Ntext),
	$asm_index_pass1(Index, Csym),
	$asm_uniq( Lsym, EPtable ), 
	$closetail( Lsym ),
	$closetail( EPtable ),
	$asmpass1_fillin( EPtable, Csym ),
	$asmpass1_setundef( Csym, Npsc, 0),
	!.

$asm_index_pass1([],_).
$asm_index_pass1([pred(_,_)|Rest], Csym) :- $asm_index_pass1(Rest, Csym).
$asm_index_pass1([arglabel(T,Val,Label)|Rest],Csym) :-
	(T ?= c ->
	     $member1((Val, 0, _), Csym);
	     (T ?= s -> 
	         (Val = (Str, Ar), $member1((Str, Ar, _), Csym)) ;
	         true
	     )
	),
	$asm_index_pass1(Rest, Csym).

$asm_pass1([],_,_,Lc,Lc).
$asm_pass1([Inst| Rest], Lsym, Csym, Lc, NLc):-
     (Inst \= label(_) ->
         ($asm_pass1(Inst,Csym,N),
          Lc0 is Lc + N
	 ) ;
	 (Inst = label(X),
          $member1((X, Lc), Lsym),
	  Lc0 = Lc
	 )
    ),
    $asm_pass1(Rest, Lsym, Csym, Lc0, NLc).

		
:- mode $asm_pass1(++,?,-).

$asm_pass1( label(X),                 _,  0).
$asm_pass1( getpvar(V,R),             _,  8).
$asm_pass1( getpval(V,R),             _,  8).
$asm_pass1( getstrv((S,N),V),Csym,        8) :- $member1((S,N,_),Csym).
$asm_pass1( gettval(R,R1),            _,  8).
$asm_pass1( getcon(C,R),Csym,             8) :- $member1((C,0,_), Csym).
$asm_pass1( getnil(R),                _,  4). 
$asm_pass1( getstr((S,N),R),Csym,         8) :- $member1((S,N,_),Csym).
$asm_pass1( getlist(R),               _,  4).
$asm_pass1( unipvar(V),               _,  4).
$asm_pass1( unipval(V),               _,  4).
$asm_pass1( unitvar(R),               _,  4).
$asm_pass1( unitval(R),               _,  4).
$asm_pass1( unicon(C),Csym,               8) :- $member1((C,0,_),Csym).
$asm_pass1( uninil,                   _,  4).
$asm_pass1( getnumcon(I,R),           _,  8).
$asm_pass1( putnumcon(N,R),           _,  8).
$asm_pass1( putpvar(V,R),             _,  8).
$asm_pass1( putpval(V,R),             _,  8).
$asm_pass1( puttvar(R,R1),            _,  8).
$asm_pass1( putstrv((S,N),V),Csym,        8) :- $member1((S,N,_),Csym).
$asm_pass1( putcon(C,R),Csym,             8) :- $member1((C,0,_),Csym).
$asm_pass1( putnil(R),                _,  4).
$asm_pass1( putstr((S,N),R),Csym,         8) :- $member1((S,N,_),Csym).
$asm_pass1( putlist(R),               _,  4).
$asm_pass1( bldpvar(V),               _,  4).
$asm_pass1( bldpval(V),               _,  4).
$asm_pass1( bldtvar(R),               _,  4).
$asm_pass1( bldtval(R),               _,  4).
$asm_pass1( bldcon(C),Csym,               8) :- $member1((C,0,_),Csym).
$asm_pass1( bldnil,                   _,  4).
$asm_pass1( uninumcon(N),             _,  8). 
$asm_pass1( bldnumcon(N),             _,  8).
$asm_pass1( getfloatcon(I,R),         _,  8).
$asm_pass1( putfloatcon(I,R),         _,  8).
$asm_pass1( unifloatcon(N),           _,  8). 
$asm_pass1( bldfloatcon(N),           _,  8).
$asm_pass1( test_unifiable(R1,R2,R3), _,  8).

$asm_pass1( getlist_k(R),                   _,  4).
$asm_pass1( getlist_k_tvar_tvar(R0,R1,R2),  _,  8).
$asm_pass1( getlist_tvar_tvar(R0,R1,R2),    _,  8).
$asm_pass1( getcomma(R),                    _,  4).
$asm_pass1( getcomma_tvar_tvar(R0,R1,R2),   _,  8).

$asm_pass1( trymeelse(L,A),           _,  8).
$asm_pass1( retrymeelse(L,A),         _,  8).
$asm_pass1( trustmeelsefail(A),       _,  4).
$asm_pass1( try(L,A),                 _,  8).
$asm_pass1( retry(L,A),               _,  8).
$asm_pass1( trust(L,A),               _,  8).
$asm_pass1( getpbreg(V),              _,  4).
$asm_pass1( gettbreg(R),              _,  4).
$asm_pass1( putpbreg(V),              _,  4).
$asm_pass1( puttbreg(R),              _,  4).

$asm_pass1( switchonterm(R,L,L1),     _, 12).
$asm_pass1( arg(I,T,X),               _,  8).
$asm_pass1( arg0(I,T,X),              _,  8).
$asm_pass1( switchonbound(R, L1, L2), _, 12).
$asm_pass1( switchonlist(R,L,L1),     _, 12).

$asm_pass1( get_tag(R1,R2),           _,  8).

$asm_pass1( movreg(R,R1),             _,  8).
$asm_pass1( negate(R),                _,  4).
$asm_pass1( and(R,R1),                _,  8).
$asm_pass1( or(R,R1),                 _,  8).
$asm_pass1( lshiftl(R,R1),          _,  8).
$asm_pass1( lshiftr(R,R1),          _,  8).
$asm_pass1( addreg(R,R1),             _,  8).
$asm_pass1( subreg(R,R1),             _,  8).
$asm_pass1( mulreg(R,R1),             _,  8).
$asm_pass1( divreg(R,R1),             _,  8).
$asm_pass1( idivreg(R,R1),            _,  8).

$asm_pass1( putdval(V,R),             _,  8).
$asm_pass1( putuval(V,R),             _,  8).

$asm_pass1( call(P,N,B),Csym,           8) :- 
	N >= 0 -> $member1((P,N,_),Csym) ; true.
$asm_pass1( allocate(_),              _,  4).
$asm_pass1( deallocate,               _,  4).
$asm_pass1( proceed,                  _,  4).
$asm_pass1( execute((P,N)),Csym,          8) :- $member1((P,N,_),Csym).

$asm_pass1( calld(P,N,B),Csym,          8) :- 
	N >= 0 -> $member1((P,N,_),Csym) ; true.
$asm_pass1( jump(L),                  _,  8).
$asm_pass1( jumpz(L,R),               _,  8).
$asm_pass1( jumpnz(L,R),              _,  8).
$asm_pass1( jumplt(L,R),              _,  8).
$asm_pass1( jumple(L,R),              _,  8).
$asm_pass1( jumpgt(L,R),              _,  8).
$asm_pass1( jumpge(L,R),              _,  8).

$asm_pass1( fail,                     _,  4).
$asm_pass1( noop,                     _,  4).
$asm_pass1( halt,                     _,  4).
$asm_pass1( builtin(S),               _,  4).

$asm_pass1( callv(B),                 _,  8).
$asm_pass1( executev,                 _,  4).

$asm_pass1( Junk,_,0) :- 
	$umsg(['*** Error in assembly: unknown opcode: ',Junk]).

/*	Fill in the values of any symbols which have not been defined
with the value -2. */

$asmpass1_setundef([], N, N) :- !.
$asmpass1_setundef([ (Pred, Arity, Val) | Rest ], Nout, Nin) :-
	$conlength(Pred, L), 
	Nmed is Nin + L + 6,
	(var(Val) -> Val = -2 ; true),
	$asmpass1_setundef(Rest, Nout, Nmed).

/*	Fill in the values of any predicates which are referenced and 
defined within this module.  Append the names of any predicates which
are defined but not referenced by this module.  Ignore predicates with
arity < 0, these are strictly internal jumps that should not go via the
symbol table.								*/

$asmpass1_fillin([], _).
$asmpass1_fillin([ (Name, Arity, LcValue) | Rest ], Table) :-
	$member1((Name, Arity, LcValue), Table),
	$asmpass1_fillin(Rest, Table).

/*	Uniq creates a list (Ulist) containing only the first label
encountered for each predicate-name arity pair and excludes all labels
whose predicate-name arity pair have an arity of -1.  Labels with an
arity of -1 are used as the targets of jump instructions only.	*/

$asm_uniq([],_).
$asm_uniq([ ((Pname, Arity,_),_) | Tail], Ulist) :-
	(Arity = -1 ;				/* internal branch */
	 $member2((Pname, Arity, _), Ulist)),   /* already present in ST */
	$asm_uniq(Tail, Ulist).
$asm_uniq([ ((Pname,Arity,_),Lc) | Tail], Ulist) :-
	$member1((Pname, Arity, Lc), Ulist),
	$asm_uniq(Tail, Ulist).


/* end asmpass11.P *********************************************/
