/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $alloctvars1.P */

/* **********************************************************************
$alloctvars1_export([$alloc_tvars/3]).

$alloctvars1_use($computil1,[_,_,_,_,$max/3,_,_,_,_,_,_,
			   $check_type/2,_,_,_,$misc/2,_,_,_,_]).
$alloctvars1_use($blist,[$append/3,$member/2,$member1/2]).
$alloctvars1_use($listutil1,[_,_,_,_,_,_,$member2/2,_]).
$alloctvars1_use($meta,[_,_,$length/2]).
********************************************************************** */

$alloc_tvars([],_,_).
$alloc_tvars([v(Vid,[o(M,Path,Lit,N,s,P)])|Vars],st(Clist,Vlist),LastGoals) :-
    $check_type(P,t),
    $misc(P,Misc), $member1(use(Use),Misc), $member1(nouse(NoUse),Misc),
    $alloctvars_chkconflicts(Vid,Lit,M,[o(M,Path,Lit,N,s,P)],
    					Clist,Vlist,Use,NoUse,LastGoals),
    $alloc_tvars(Vars,st(Clist,Vlist),LastGoals).
$alloc_tvars([v(Vid,[O1|ORest])|Vars],Syms,LastGoals) :-
    $alloc1(Vid,O1,ORest,Syms,LastGoals),
    $alloc_tvars(Vars,Syms,LastGoals).


$alloctvars_chkconflicts(Vid,Lit0,M,Olist,Clist,Vlist,Use,NoUse,LastGoals) :-
	((Lit0 =:= 0, Lit1 = 1) ;	/* head */
	 (Lit0 =\= 0, Lit1 = Lit0)
	),
	$alloc_get_first_noninline(Lit1,Clist,0,Nargs),
	$alloctvars_chkconflicts1(Vid,Nargs,M,Lit1,
				Olist,Vlist,Use,NoUse,LastGoals).

$alloctvars_chkconflicts1(_,0,_,_,_,_,_,_,_).
$alloctvars_chkconflicts1(Vid,N,M,Lit,Olist,Vlist,Use,NoUse,LastGoals) :-
	$alloc_collect_lastgoals(Lit,LastGoals,ChLastGoals),
	(($alloc_no_conflict(Vid,N,ChLastGoals),
	  $member2(o(_,_,Lit,N,t,_),Olist),
	  $member1(N, Use),
	  $alloc_request(M,N,Lit,VList)) ;
	 ($member1(N, NoUse))
	),
	N1 is N - 1,
	$alloctvars_chkconflicts1(Vid,N1,M,Lit,
				Olist,Vlist,Use,NoUse,LastGoals).


$alloc_get_first_noninline(Lit,[],N,N).
$alloc_get_first_noninline(Lit0,[c(Lit1,Nargs0,Prag)|CRest],Nargs1,Nargs) :-
	((Lit0 =:= Lit1,
	  ($member2(inline,Prag) ->
		Nargs2 = Nargs1 ;
		$max(Nargs0,Nargs1,Nargs2)
	  )
	 ) ;
	 (Lit0 =\= Lit1, Nargs2 = Nargs1)
	),
	$alloc_get_first_noninline(Lit0,CRest,Nargs2,Nargs).


/*   "$alloc_request" goes through the list of variable occurrences, and for
      each variable in the head with an occurrence number less than or equal
      to M, and requests that it not use register N, by adding the
      pragma `nouse(N)'.						*/

:- index($alloc_request,4,4).

$alloc_request(_,_,_,[]).
$alloc_request(M,N,Lit,[v(Vid,Occlist)|VRest]) :-
    $alloc_request1(M,N,Lit,Occlist),
    $alloc_request(M,N,Lit,VRest).


$alloc_request1(_,_,_,X) :- var(X).
$alloc_request1(M,_,Lit,[o(M1,Path,L,_,_,_)|_]) :-
    ((M1 >= M) ; (L =\= Lit, L =\= Lit - 1)).
$alloc_request1(M,N,Lit,[o(M1,Path,L,_,_,P)|ORest]) :-
    M1 < M,
    ((L is Lit) ; (L is Lit - 1)),
    $misc(P,Misc), 
    (($member1(use(Uselist),Misc), $member2(N,Uselist)) ;
     ($member1(nouse(Nouselist),Misc), $member1(N,Nouselist))
    ).
$alloc_request1(_,_,_,[o(_,_,_,_,_,P)|_]) :- not($check_type(P,t)).

/* "$alloc1" does the first phase of register allocation for temporary
    variables.  It adds `use(N)' pragmas to guide usage of registers at
    the actual allocation time, and also adds `nouse(N)' pragmas to
    indicate which registers should not be used at some point.		*/

$alloc1(_,_,[],_,_).
$alloc1(Vid,O1, OList, st(_,Vlist),LastGoals) :-
    O1 = o(M,0,0,N,t,P1),
    $check_type(P1,t),
    $alloc_collect_lastgoals(1,LastGoals,ChLastGoals),
    $alloc_no_conflict(Vid,N,ChLastGoals),
    $member1(o(_,_,1,N,t,P2),OList),		/* args in same place	*/
    $misc(P1,Misc), $member1(use(L1),Misc),
    $member1(N,L1),
    $alloc_request(M,N,0,Vlist),
    OList = [_|ORest],
    $alloc1(Vid,O1, ORest, Vlist,LastGoals).
$alloc1(Vid,o(M,Path,Lit,M1,_,P1),OList, st(Clist,Vlist),LastGoals) :-
    $check_type(P1,t), $misc(P1,Misc),
    $member1(use(Use),Misc), $member1(nouse(NoUse),Misc),
    $alloctvars_chkconflicts(Vid,Lit,M,OList,Clist,Vlist,Use,NoUse,LastGoals).
$alloc1(_,_,_,_,_).


$alloc_collect_lastgoals(Chunk,[],[]).
$alloc_collect_lastgoals(Chunk,[chunk(Chunk0,Call)|Rest],ChLastGoals) :-
	((Chunk =:= Chunk0, ChLastGoals = [Call|ChRest]) ;
	 (Chunk =\= Chunk0, ChLastGoals = ChRest)
	),
	$alloc_collect_lastgoals(Chunk,Rest,ChRest).


$alloc_no_conflict(Vid,N,[]).
$alloc_no_conflict(Vid,N,['_call'(P,Args,_)|CRest]) :-
	$length(Args,Arity),
	((Arity < N ) ;
	 (Arity >= N, $alloc_check_args(Args,N,Vid))
	),
	$alloc_no_conflict(Vid,N,CRest).

$alloc_check_args([v(Vid,_)|_],1,Vid).
$alloc_check_args([_|Args],N,Vid) :-
	N > 1,
	N1 is N-1,
	$alloc_check_args(Args,N1,Vid).

/* ---------------------------- $alloctvars1.P ---------------------------- */

