
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

extern void top_level();
extern void init_commands();
extern int window_size;

typedef void (*PFI)(int);

struct Command {
  char* name;
  int ID;
  PFI exec;
  int arg_type;
};

extern Command commands[];

enum {
#define NAMES
#define use(String,ID,Function,ARGTYPE)\
  ID,
#include "commands.h"
#undef use
#undef NAMES
LAST_COMMAND
};

#define NAMES
#define use(String,ID,Function,ARGTYPE)\
extern void Function(int);
#include "commands.h"
#undef use
#undef NAMES

extern void service_interrupt();
extern void service_illegal_instruction();
extern void service_bus_error();
extern void service_segmentation_fault();
extern void service_error(char*);
extern void top_level_error(char* s =0);
extern void top_level_failure();
extern void top_level_success();
extern void top_level_normal_termination();

extern int BREADTH_LIMIT;
extern int DEPTH_LIMIT;

typedef struct {
#ifdef WITH_GC
  int new_space_underflow;
#endif
  int end;
  int last_low;
  int maximum;
  int total;
  void clear() {
    end = last_low = maximum = total = 0;
#ifdef WITH_GC
    new_space_underflow = 0;
#endif
  }
  void enter(Cell* Low, Cell* High) {
#ifdef WITH_GC
    Cell low = ((Low >= HMIN) ? (Low - HMIN) + (H2 - H0) : (Low - H0));
    Cell high = (High - HMIN) + (H2 - H0);
    if (Low < HMIN && end == 0) new_space_underflow++;
#else
    Cell low = Low - H0;
    Cell high = High - H0;
#endif
    total += high - last_low;
    last_low = low;
    maximum = (maximum > high) ? maximum : high;
  }
#ifdef WITH_GC
  void gc_enter(Cell* H_before, Cell* H2_before) {
    Cell before = (H_before - HMIN) + (H2_before - H0);
    Cell after = (H2 - H0);
    total += before - last_low;
    last_low = after;
    maximum = (maximum > before) ? maximum : before;
  }
#endif
  void print() {
    printf("Total Cells Allocated: %d\n", total);
    printf("Maximum Number of Cells in Use: %d\n", maximum);
#ifdef WITH_GC 
    printf("New Space Underflows: %d\n", new_space_underflow);
#endif
  }
} HeapData;

extern HeapData heap_usage;
extern int trace_heap_flag;

struct StackData {
  Cell* max_e;
  Cell* min_b;
  inline void enter(Cell* e, Cell* b) {
    max_e = (max_e > e) ? max_e : e;
    min_b = (min_b < b) ? min_b : b;
  }
  void clear() {
    max_e = E0;
    min_b = B0;
  }
  void print() {
    printf("Max Number of Words in Env Stack: %d\n", max_e - E0);
    printf("Max Number of Words in CP Stack: %d\n", B0 - min_b);
  }
};

