
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

typedef int Cell;
typedef Cell* CellPtr;
typedef void (*PF)();

 /* ptr is a pointer of some sort; transformed into a cell value */
inline Cell cell(void* ptr)
{
  return (Cell) ptr;
}

/* ptr is a cell address: with the tag, make it a cell */
 /* pointing to some other cell. Can't be a constant */
#define make_cell(tag,ptr) (cell(ptr) | (tag))

 /* get a pointer back from a cell */
#define instrp(cell) ((Instr*) (cell))
#define cellp(cell) ((Cell*) (cell))
#define procp(cell) ((PF) (cell))

#define TAGREF 3
#define TAGLIST 2
#define TAGSTRUCT 1
#define TAGCONST 0
#define GETTAG 3
#define CLEARTAG ~GETTAG

#define LONGTAGINT 0
#define LONGTAGATOM 4
#define GETLONGTAG 7

#define get_tag(cell) ((cell) & GETTAG)

 /* make an INTEGER */
 /* that way, once the tag is checked, can perform arithmetic directly */
#define make_int(value) ((value) << 3)
 /* give the print value of an integer */
inline int get_int(Cell value)
{
  return value >> 3;
}

#define is_int(value) (((value) & GETLONGTAG) == LONGTAGINT)

 /* make an ATOM */
 /* that way, once the tag is checked, can perform arithmetic directly */
 /* should be aligned: easiest way is to force the string table to start */
 /* all the strings on a word boundary, starting at an odd address */
#define make_atom(value) (value)
 /* give the print value of an integer */
#define get_id(value) (value)
inline char* get_string(Cell value) 
{
  return (char*) value;
}

 /* only to be used to distinguish an atom from an integer */
#define is_atom(value) (((value) & GETLONGTAG) == LONGTAGATOM)

 /* make a POINTER */
 /* should be aligned on word boundary */
inline Cell make_ptr(int tag, Cell* addr)
{
  return (int) addr | tag;
}

 /* get the address of a pointer */
inline Cell* addr(Cell ptr)
{
  return (Cell*) (ptr & CLEARTAG);
}

 /* get the right value of a pointer */
#define rvalue(ptr) *addr(ptr)
 /* get the car */
#define car(ptr) *addr(ptr)
 /*  get the cdr */
#define cdr(ptr) *(addr(ptr) + 1)
 /* get the left value of a pointer */
#define lvalue(ptr) *addr(ptr)
