
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, 1988, Aquarius Project, UC Berkeley */

/*

  |--------------------------------------| <- B0
  |                                      |
  |         Choice Point Stack           |
  |                                      |
  |-----------------|--------------------| <- B
  |                \|/                   |
  |                                      |
  |                                      |
  |                /|\                   |
  |-----------------|--------------------| <- E
  |                                      |
  |        Environment Stack             |
  |                                      | <- E0
  |--------------------------------------| <- HMAXHARD
  |                                      | <- HMAXSOFT
  |         New Space                    |
  |                                      | <- HMIN
  |--------------------------------------|
  |          Marking Area                |
  |                                      |
  |--------------------------------------| <- MKMIN
  |                                      | <- TR0
  |            Trail Stack               |
  |                                      |
  |-----------------|--------------------|  <- TR
  |                \|/                   |
  |                                      |
  |                                      |
  |                /|\                   |
  |-----------------|--------------------|  <- H2
  |                                      |
  |         Global Stack                 |
  |                                      |
  |--------------------------------------|  <- H0

*/

extern CellPtr S;
extern CellPtr B0;
extern CellPtr B;
extern CellPtr E0;
extern CellPtr E;
extern CellPtr TR;
extern CellPtr TR0;
extern CellPtr H0;
extern CellPtr H;
extern CellPtr R;
extern CellPtr R0;
extern InstrPtr P0;
extern InstrPtr P;

#ifdef WITH_GC
extern CellPtr H2;
extern CellPtr TR2;
extern CellPtr E2;
extern CellPtr HMIN;
extern CellPtr HMAXSOFT;
extern CellPtr HMAXHARD;
const int HMAX_SECURITY = 256;
extern unsigned char* MKMIN;
#endif 

 /* points to an escape that signals successful termination */
extern InstrPtr CP0;
 /* points to a fail instruction */
extern InstrPtr FP0;
 /* points to an escape that signals unsuccessful termination */
extern InstrPtr NP0;
 /* points to the metacall escape */
extern  InstrPtr MP0;
extern  int next_instruction;
enum {
#define use(Name,ID,Coeff,Reg,Type)\
  ID,
#include "memory_sizes.h"
#undef use
  LAST_SIZE
  };
extern int memory_sizes[];
extern Cell NIL;
extern Cell LIST_FUNCTOR;

class Memory {
 public:
  void init();
  StringTable* ST;
  Memory(StringTable& table);
  void allocate();
};

#define NUMBER_OF_REGISTERS 8
extern Cell X[];

 /* layout of an environment */
 /* B   E   P   Y1   Y2   Y3 ... */
 /*-3  -2  -1    0    1    2     */
enum {
  B_ENV_OFFSET = -3,
  E_ENV_OFFSET = -2,
  P_ENV_OFFSET = -1,
  Y1_ENV_OFFSET = 0,
  };

 /* position of E above the top of the stack when an env is created */
enum {
  E_TOP_OFFSET = 3
  };

 /* Layout of a choice point */
 /* E   H   TR   P   SIZE X1   X2   X3 ...  */
 /* 1   2   3    4   5    6    7    8   9       */
 /* the CP stack grows donwards, so Xi are the first pushed on the stack */
 /* and B points at the top of the stack */
 /* A is the top of the environment stack */
 /* always equals to E except for those stupid intra-clause choice */
 /* points */
enum {
  E_CP_OFFSET = 1,
  H_CP_OFFSET = 2,
  TR_CP_OFFSET = 3,
  P_CP_OFFSET = 4,
  SIZE_CP_OFFSET = 5,
  X1_CP_OFFSET = 6,
  FIXED_CP_SIZE = 5
  };
