
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

#ifdef WITH_GC
#include <stream.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "tags.h"
#include "instr.h"
#include "hash_table.h"
#include "string_table.h"
#include "scan.h"
#include "inst_args.h"
#include "inst_table.h"
#include "memory.h"
#include "basics.h"
#include "top_level.h"
#include "gc.h"
#include "mark_copy.h"

 /* ENVS */

void Env::mark_sweep()
{
#ifdef WITH_VIRTUAL_BACK
  Cell* y = e + Y1_ENV_OFFSET + already_treated;
  Cell* y0 = e + Y1_ENV_OFFSET + size;
  for (; y < y0; y++) {
    Cell* ptr = y;
    Cell val = *ptr;
    while (get_tag(val) == TAGREF && addr(val) >= E2 && addr(val) != ptr) {
      ptr = addr(val);
      val = *ptr;
    }
    if (get_tag(val) == TAGCONST) continue;
    if (to_new_space(addr(val)))
      mark_from_base_sweep(ptr);
  }
#else
  Cell* y = e + Y1_ENV_OFFSET + already_treated;
  Cell* y0 = e + Y1_ENV_OFFSET + size;
  for (; y < y0; y++) {
    if (get_tag(*y) == TAGCONST) continue;
    if (to_new_space(addr(*y)))
	mark_from_base_sweep(y);
  }
#endif
}

 /* CHOICE POINTS */

 /* creates a choice point at the top that is above everything else. */
 /* It is easier to code gctrail that way: don't have to worry about */
 /* boundary conditions any more.  */
void setup_cps_pass1_sweep()
{
 /* creates a topmost choice point */
  B -= FIXED_CP_SIZE;
  B[E_CP_OFFSET] = cell(E);
  B[H_CP_OFFSET] = cell(H);
  B[TR_CP_OFFSET] = cell(TR);
  B[P_CP_OFFSET] = 0; /* unused */
  B[SIZE_CP_OFFSET] = 0;

 /* find BMIDDLE and B2 */
  Cell* b = B;
  while (cellp(b[H_CP_OFFSET]) > HMIN) {
    b += FIXED_CP_SIZE + b[SIZE_CP_OFFSET];
  }
  B2 = b;

 /* treat the case of the cps under B2 such that B.h == HMIN now */
  while (cellp(b[H_CP_OFFSET]) == HMIN) {
    b[H_CP_OFFSET] = cell(H2);
    b += FIXED_CP_SIZE + b[SIZE_CP_OFFSET];
  }

 /* set B2 to be above TR2 as well; save previous contents */
  SAVED_CP.tr = cellp(B2[TR_CP_OFFSET]);
  SAVED_CP.e = cellp(B2[E_CP_OFFSET]);
  SAVED_CP.h = cellp(B2[H_CP_OFFSET]);
  TR2 = min(TR2, SAVED_CP.tr);
  E2 = max(E2, SAVED_CP.e);
  B2[TR_CP_OFFSET] = cell(TR2);
  B2[E_CP_OFFSET] = cell(E2);
  B2[H_CP_OFFSET] = cell(H2);

 /* just to limit the modifications with the mark_copy case */
  HMIDDLE = HMIN;
}

 /* just replace unmarked2 by unmarked */
void Choice::virtual_backtrack_sweep()
{
#ifdef WITH_VIRTUAL_BACK
  Cell* var0 = tr;
  Cell* var = cellp(b[TR_CP_OFFSET]);
  tr = var;
  for (; var > var0; var--) {
    Cell* ptr = addr(*var);
    if (ptr >= E0) {
      Cell val = *ptr;
      while (get_tag(val) == TAGREF && addr(val) >= E0 && addr(val) != ptr) {
	ptr = addr(val);
	val = *ptr;
      }
      if (pointer_to_new(*ptr) && unmarked(addr(*ptr)))
	*addr(*var) = *var;
    } else if (ptr >= HMIN) {
      if (unmarked(ptr)) 
	*ptr = *var;
    }
  }
#endif
}

void Choice::mark_sweep()
{
#ifdef WITH_VIRTUAL_BACK
  virtual_backtrack_sweep();
  Cell* x = b + X1_CP_OFFSET;
  Cell* x0 = x + b[SIZE_CP_OFFSET];
  for (; x < x0; x++) {
    Cell* ptr = x;
    Cell val = *ptr;
    while (get_tag(val) == TAGREF && addr(val) >= E2 && addr(val) != ptr) {
      ptr = addr(val);
      val = *ptr;
    }
    if (get_tag(val) == TAGCONST) continue;
    if (to_new_space(addr(val)))
	mark_from_base_sweep(ptr);
  }
#else
  Cell* x = b + X1_CP_OFFSET;
  Cell* x0 = x + b[SIZE_CP_OFFSET];
  for (; x < x0; x++) {
    if (get_tag(*x) == TAGCONST) continue;
    if (to_new_space(addr(*x)))
      mark_from_base_sweep(x);
  }
#endif
}

 /* THE TRAIL STACK */

void gctrail_pass12_sweep()
{
  register Cell* tr0 = cellp(B[TR_CP_OFFSET]);
  register Cell* tr = cellp(B2[TR_CP_OFFSET]);
  for (; tr > tr0; tr--) {
    register Cell* ptr = addr(*tr);
    if (ptr >= E2 || (ptr < E0 && ptr >= HMIN))
      continue;
    if (pointer_to_new(*ptr))
      mark_from_base_sweep(ptr);
  }
}

void gctrail_pass1_sweep()
{
  gctrail_pass11();
  gctrail_pass12_sweep();
}

void gctrail_pass2_sweep()
{
  TrailCP cp(B2, B);
  Cell* tr0 = cp.tr;
  Cell* tr = cp.tr;
  Cell* copy_tr = cp.tr;
  while (cp.nonempty()) {
    tr = tr0;
    tr0 = cp.next_tr;
    for (; tr > tr0; --tr) {
      Cell* ptr = addr(*tr);
      switch (cp.pass2_action_sweep(ptr)) {
      case TRAIL_SKIP:
	break;
      case TRAIL_RELOC:
	*copy_tr-- = relocate(TAGREF, ptr);
	break;
      case TRAIL_IND_RELOC:
	*ptr = check_and_relocate(*ptr);
	*copy_tr-- = *tr;
	break;
      }
    }
    cp.update_tr(copy_tr);
    cp.next();
  }
}

 /* control stacks */

 /* just replace marking by sweep marking */

void gccontrol_pass1_sweep()
{
 /* first, take care of living cells */
  Env env(E);
  for (;;) {
    if (env.e <= E2) {
      if (env.e == E2)
	env.mark_sweep();
      break;
    }
    env.mark_sweep();
    env.next();
  }

 /* now, take care of preserved cells */
  Choice cp(E, B);
  for (;;) {
    if (cp.last()) break;
    cp.mark_sweep();
    cp.mark_preserved_envs_sweep();
    cp.next();
  }
}

 /* simple, sweep marking */

 /* suppose p is a global stack pointer; can't point to env stack */
 /* should be recoded to use a table lookup instead of all those tests */

static DownStack MARK_SWEEP_STACK;
void mark_from_base_sweep(Cell* p)
{
  MARK_SWEEP_STACK.init(B);
  MARK_SWEEP_STACK.push(p);
  for (;;) {
    Cell* var;
    if (MARK_SWEEP_STACK.nonempty())
      var = MARK_SWEEP_STACK.pop();
    else
      break;

    switch (get_tag(*var)) {
    case TAGCONST:
      break;
    case TAGREF: 
      {
	Cell* ptr = addr(*var);
	if (ptr >= HMIN && unmarked(ptr)) {
	  mark(ptr);
	  MARK_SWEEP_STACK.push(ptr);
	}
      }
      break;
    case TAGLIST:
      {
	Cell* list = addr(*var);
	if (list >= HMIN) {
	  for (int i = 0; i < 2; i++) {
	    if (unmarked(list + i)) {
	      mark(list + i);
	      MARK_SWEEP_STACK.push(list + i);
	    }
	  }
	}
      }
      break;
    case TAGSTRUCT:
      {
	Cell* str = addr(*var);
	if (str >= HMIN && unmarked(str)) {
	  int i0 = get_int(str[1]) + 2;
	  for (int i = 0; i < 2; i++)
	    mark(str + i);
	  for (i = 2; i < i0; i++) {
	    mark(str + i);
	    MARK_SWEEP_STACK.push(str + i);
	  }
	}
      }
      break;
    }
  }
}

void mark_compact_stats()
{
  gc_scanned += H_entry_value - HMIN;
  gc_survivors += H2 - H2_entry_value;
  tr_scanned += TR2_entry_value - TR_entry_value;
  tr_survivors += TR2_entry_value - TR;
  if (DISPLAY_GC) {
    cout << "gc(";
    display_stat1("global", H_entry_value - HMIN, H2 - H2_entry_value);
    display_stat1("trail",TR2_entry_value-TR_entry_value, TR2_entry_value-TR);
  }
}

void init_marking_table_sweep()
{
#ifdef WITH_VIRTUAL_BACK
  if (MARK != 2) return;
#else
  if (MARK != 1) return;
#endif
  register int* p = (int*) MKMIN;
  register int* p0 = HMIN;
  while (p < p0)
    *p++ = 0;
}

 /* basic initializations */

 /* need to initialize MARK2 in case this is used with mark_copy */
void gc_init_sweep()
{
#ifdef WITH_VIRTUAL_BACK
  MARK = 2 * ((GC_COUNTER % 127) + 1); /* values from 2 to 254 */
#else
  MARK = (GC_COUNTER % 255) + 1;       /* values from 1 to 255 */
#endif
  GC_COUNTER++;
}

 /* top level */
 /* assumes that GC_DOES_COPY. Should also work if everything is above */
 /* the topmost choice point, though slower than the special purpose */
 /* fast_copy garbage collector */

void mark_compact()
{
  init_stats();
  store_regs_in_env();
  setup_cps_pass1_sweep();
  gc_init_sweep();
  init_marking_table_sweep();
  cp_to_cp_forward();
  gctrail_pass1_sweep();
  cp_to_cp_backward();
  gccontrol_pass1_sweep();
  global_sweep();
  gccontrol_pass2();
  cp_to_cp_forward();
  gctrail_pass2_sweep();
  cp_to_cp_backward();
  restore_top_env();
  restore_cps();
  mark_compact_stats();
  compute_stats();
}

#endif
