
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Calculate lifetimes of all temporary
% variables using the varlist.
% (Permanents must be allocated beforehand)
% Uses fence(_) to forget temporaries.
% Two passes needed: Down & back up.
% Lots of verbose superfluous code used.

lifetime(VarList, LifeList, ForwList, BackList) :-
	ForwList=[[]|_],
	forward(VarList, ForwList, _),
	backward(VarList, BackList, []),
	mapclause(intersectv, ForwList, BackList, LifeList), !.


% Forward Pass:
% Watch out for data flow!
% FLast is an output, FLeft is given.
forward([X|Rest], [FLeft,FRight|FRest], FLast) :-
	var(X), !,
	unionv([X], FLeft, FRight),
	forward(Rest, [FRight|FRest], FLast).
forward([fence(_)|Rest], [_,[]|FRest], FLast) :-
	forward(Rest, [[]|FRest], FLast).
forward([Dis|Rest], [FLeft,FIn,FRight|FRest], FLast) :-
	Dis=(_;_),
	forwdis(Dis, [FLeft,FIn], FRight),
	forward(Rest, [FRight|FRest], FLast).
forward([_|Rest], [FLeft,FLeft|FRest], FLast) :-
	forward(Rest, [FLeft|FRest], FLast).
forward([], [FLast], FLast).

% Given: FLeft.
% To be calculated: AIn,BIn,FRight.
forwdis((A;B), [FLeft,(AIn;BIn)], FRight) :-
	AIn=[FLeft|_],
	forward(A, AIn, ARight),
	forwdis(B, [FLeft,BIn], BRight),
	unionv(ARight, BRight, FRight).
forwdis(B, [FLeft,BIn], FRight) :-
	BIn=[FLeft|_],
	forward(B, BIn, FRight).


% Backward Pass:
% Watch out for convoluted data flow!
% BLast is an input, others (BLeft, BRight) are outputs.
backward([X|Rest], [BLeft,BRight|BRest], BLast) :-
	var(X), !,
	backward(Rest, [BRight|BRest], BLast),
	unionv([X], BRight, BLeft).
backward([fence(_)|Rest], [[],L|BRest], BLast) :-
	backward(Rest, [L|BRest], BLast).
backward([Dis|Rest], [BLeft,BIn,BRight|BRest], BLast) :-
	Dis=(_;_),
	backward(Rest, [BRight|BRest], BLast),
	backdis(Dis, [BLeft,BIn,BRight]).
backward([_|Rest], [BLeft,BLeft|BRest], BLast) :-
	backward(Rest, [BLeft|BRest], BLast).
backward([], [BLast], BLast).

% Given: BRight.
% To be calculated: XIn,YIn,BLeft.
backdis((X;Y), [BLeft,(XIn;YIn),BRight]) :-
	XIn=[XLeft|_],
	backward(X, XIn, BRight),
	backdis(Y, [YLeft,YIn,BRight]),
	unionv(XLeft,YLeft,BLeft).
backdis(Y, [BLeft,YIn,BRight]) :-
	YIn=[BLeft|_],
	backward(Y, YIn, BRight).
