(in-package "LAPIDARY" :use '("LISP" "KR"))

(defun modifiers-handler (gadget value)
  ;; find which button was selected--if a button was deselected, nothing
  ;; needs to be done
  (let ((button (car (set-difference value (g-value gadget :old-value) 
				     :test #'string-equal)))
	(mouse (g-value gadget :parent :mouse)))
    
    ;; if the button is "any modifier", clear the remaining modifier keys
    ;; and the keyboard keys.
    ;; set the mouse button to leftdown if a mouse button is not already set
    (cond ((string-equal button "any modifier")
	   (when (not (g-value mouse :value))
		 (lapidary-error "You cannot use the any modifier prefix with keyboard characters.
You need to create a separate event for each set of
modifiers and keyboard combinations that you want")
		 (s-value gadget :value (g-value gadget :old-value))
		 (return-from modifiers-handler))
	   (s-value gadget :value '("any modifier")))

	  ;; if the button is "shift", clear the "any modifier" button.
	  ;; since shift is not a valid modifier with a key, clear the
	  ;; key and any-key entries and set the mouse button to leftdown
	  ;; if it is not already set
	  ((string-equal button "shift")
	   (when (not (g-value mouse :value))	       
		 (lapidary-error "shift is built-in to the keyboard characters
and thus is not a valid selection")
		 (s-value gadget :value (g-value gadget :old-value))
		 (return-from modifiers-handler))
	   (s-value gadget :value 
		    (delete "any modifier" value :test #'string-equal)))

	  ;; if the buttons are "control" or "meta", clear the "any modifier"
	  ;; and any-key buttons. If the any-key button is set, set the
	  ;; mouse button to leftdown
	  (t 
	   (when (g-value gadget :parent :any-key :value)
		 (lapidary-error (format nil "~S is not a valid modifier for any keypress" (pop value)))
		 (s-value gadget :value value)
		 (return-from modifiers-handler))
	   (s-value gadget :value 
		    (delete "any modifier" value :test #'string-equal))))
    ;; save the new value
    (s-value gadget :old-value (g-value gadget :value))))