
(in-package "DEMO-OTHELLO" :use '("LISP" "USER" "KR"))

(defvar score-box-piece-1 NIL)
(defvar score-box-piece-2 NIL)

(defun make-lapidary-usable (window)
  
  (let (editor-win-agg editor-agg feedback-agg feedback)
  
    ;;; create the top level aggregate in the editor window
    (setf editor-win-agg (g-value window :aggregate))
  
    ;;; create the aggregate that contains the editable, selectable objects
    (setq editor-agg
	  (kr:create-instance 
	   nil opal:aggregate 
	   (:overlapping t)
	   (:left 0)
	   (:top 0)
	   (:width (o-formula (gv window :width)))
	   (:height (o-formula (gv window :height)))
	   (:selection-type (o-formula (lapidary::classify-selections)))))
    
    (opal:add-component editor-win-agg editor-agg)
    (s-value window :editor-agg editor-agg)

    ;;; create the feedback aggregate
    (setf feedback-agg (kr:create-instance nil opal:aggregate 
					   (:overlapping nil)))
    (opal:add-component editor-win-agg feedback-agg)
  
    (s-value window :feedback-agg feedback-agg)

    (push window (g-value lapidary::move-inter :window))
    (push editor-agg (g-value lapidary::move-inter :editor-agg-list))

    (setf feedback (opal:add-component 
		    feedback-agg
		    (kr:create-instance
		     nil opal:rectangle
		     (:draw-function :xor)
		     (:name "Interim Rect feedback")
		     (:left (o-formula (first (gvl :box))))
		     (:top (o-formula (second (gvl :box))))
		     (:width (o-formula (third (gvl :box))))
		     (:height (o-formula (fourth (gvl :box))))
		     (:visible nil)
		     (:box '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :create-rect-feedback feedback)

    (setf feedback (opal:add-component 
		    feedback-agg
		    (kr:create-instance
		     nil opal:line
		     (:draw-function :xor)
		     (:name "Interim Line feedback")
		     (:x1 (o-formula (first (gvl :box))))
		     (:y1 (o-formula (second (gvl :box))))
		     (:x2 (o-formula (third (gvl :box))))
		     (:y2 (o-formula (fourth (gvl :box))))
		     (:visible nil)
		     (:box '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :create-line-feedback feedback)

    (setf feedback (opal:add-component
		    feedback-agg
		    (kr:create-instance 
		     nil opal:roundtangle
		     (:draw-function :xor)
		     (:name "Interim Roundtangle feedback")
		     (:left (o-formula (first (gvl :box))))
		     (:top (o-formula (second (gvl :box))))
		     (:width (o-formula (third (gvl :box))))
		     (:height (o-formula (fourth (gvl :box))))
		     (:visible nil)
		     (:box '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :create-roundtangle-feedback feedback)
	  
    (setf feedback (opal:add-component
		    feedback-agg
		    (kr:create-instance
		     nil opal:circle
		     (:draw-function :xor)
		     (:name "Interim Circle feedback")
		     (:left (o-formula (first (gvl :box))))
		     (:top (o-formula (second (gvl :box))))
		     (:width (o-formula (third (gvl :box))))
		     (:height (o-formula (fourth (gvl :box))))
		     (:radius
		      (o-formula (let ((box (gvl :box)))
				   (round (min (third box) (fourth box)) 2))))
		     (:visible nil)
		     (:box '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :create-circle-feedback feedback)

    (setf feedback (opal:add-component
		    feedback-agg
		    (kr:create-instance nil opal:cursor-multi-text 
		     (:string "")
		     (:cursor-index nil)
		     (:draw-function :xor)
		     (:left (o-formula (first (gvl :box))))
		     (:top (o-formula (second (gvl :box))))
		     (:name "Interim text feedback")
		     (:visible nil)
		     (:font (o-formula 
			     (case (gv *text-info* :how-set)
			       (:font (gv *text-info* :current-font))
			       (:|<Formula>| (formula (gv *text-info* :font-formula)))
			       (:|Font From File| (gv *text-info* :font-from-file))))))))
    (s-value window :create-text-feedback feedback)

    ;;; create the feedback object for selecting a group of objects

    (setf feedback (opal:add-component 
		    feedback-agg
		    (kr:create-instance
		     nil opal:rectangle
		     (:draw-function :xor)
		     (:name "Selection feedback")
		     (:left (o-formula (first (gvl :box))))
		     (:top (o-formula (second (gvl :box))))
		     (:width (o-formula (third (gvl :box))))
		     (:height (o-formula (fourth (gvl :box))))
		     (:visible nil)
		     (:box '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :selection-feedback feedback)

    ;;; create the feedback object for moving or growing an object

    (setf feedback (opal:add-component 
		    feedback-agg
		    (kr:create-instance 
		     nil opal:rectangle
		     (:draw-function :xor)
		     (:name "Interim Rect feedback")
		     (:left (o-formula (first (gvl :points))))
		     (:top (o-formula (second (gvl :points))))
		     (:width (o-formula (third (gvl :points))))
		     (:height (o-formula (fourth (gvl :points))))
		     (:visible (o-formula (gvl :obj-over)))
		     (:points '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :move-grow-feedback feedback)

    (setf feedback (opal:add-component 
		    feedback-agg
		    (kr:create-instance 
		     nil opal:rectangle
		     (:draw-function :xor)
		     (:fast-redraw-p nil)
		     (:name "Interim Rect feedback")
		     (:left (o-formula (first (gvl :points))))
		     (:top (o-formula (second (gvl :points))))
		     (:width (o-formula (third (gvl :points))))
		     (:height (o-formula (fourth (gvl :points))))
		     (:visible (o-formula (gvl :obj-over)))
		     (:points '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :move-grow-box-feedback feedback)

    (setf feedback (opal:add-component 
		    feedback-agg
		    (kr:create-instance 
		     nil opal:line
		     (:draw-function :xor)
		     (:fast-redraw-p nil)
		     (:x1 (o-formula (first (gvl :points))))
		     (:y1 (o-formula (second (gvl :points))))
		     (:x2 (o-formula (third (gvl :points))))
		     (:y2 (o-formula (fourth (gvl :points))))
		     (:visible (o-formula (gvl :obj-over)))
		     (:points '(0 0 0 0))
		     (:line-style opal:dashed-line))))
    (s-value window :move-grow-line-feedback feedback))

  (push window lapidary::*vp-editor-list*))

(defvar control-panel-agg NIL)
(defun Make-Control-Panel ()
  (let* ((panel-bottom *bottommost-box-point*)
 	 (panel-left   (* 2 *title-line-x-offset*))
	 (panel-width  (- *rightmost-box-point* panel-left))
	 (panel-middle (+ panel-left (half panel-width))))

    (format t "***** MAKING THE CONTROL PANEL ****~%")

;    (setf control-panel-agg (user::make-othello-menu (g-value w :editor-agg)))

;    (s-value control-panel-agg
;	     :left (o-formula (- panel-middle (half (gvl :width)))))
;    (s-value control-panel-agg :top  (o-formula (- panel-bottom
;				     (gvl :height))))

;;;; Done making the fake control panel
	(create-instance 'control-panel opal:rectangle
			 (:top (o-formula (- panel-bottom
				     118)))
			 (:left (o-formula (- panel-middle (half 113)))))))
;		(:top (o-formula (- (gv Control-Panel-Agg :top)
;				    *panel-y-indent*)))
;		(:left panel-left)
;		(:width panel-width)
;		(:height (o-formula (- panel-bottom (gvl :top)))))
;	(opal:add-component Top-Agg Control-Panel)

 
(defun Make-Game-Piece-Pair (row column player)
  (let* ((square (aref board-array row column))
	 (piece1 (make-gadget user::game-piece-1))
	 (piece2 (make-gadget user::game-piece-2)))
    (s-value piece1 :left   (+ (g-value square :left) 2))
    (s-value piece1 :top    (+ (g-value square :top)  2))
    (s-value piece1 :width  (- (g-value square :width) 4))
    (s-value piece1 :height (- (g-value square :height) 4))
    (s-value piece1 :square square)
    (s-value piece1 :visible (o-formula (eq (gvl :square :player) 1)))
    (s-value piece2 :left   (+ (g-value square :left) 2))
    (s-value piece2 :top    (+ (g-value square :top)  2))
    (s-value piece2 :width  (- (g-value square :width) 4))
    (s-value piece2 :height (- (g-value square :height) 4))
    (s-value piece2 :square square)
    (s-value piece2 :visible (o-formula (eq (gvl :square :player) 2)))
    (dolist (component (get-values piece1 :components))
      (s-value component :visible (formula `(gvl :parent :visible))))
    (dolist (component (get-values piece2 :components))
      (s-value component :visible (formula `(gvl :parent :visible))))
    (opal::add-components board piece1 piece2)
    (s-value square :player player)))

(defun Make-Gadget (gadget)
  (let ((prototypes (lapidary::find-components gadget))  ;components of original
	ignore
	instances                              ;components of new gadget
	local-state-slots
	result)
    (setf instances (lapidary::make-corresponding-schemata prototypes))

    ;; set links among corresponding instances:
    (mapc #'(lambda (proto inst)              ; for each proto/inst pair
	      (with-demons-disabled
	       (s-value inst :is-a proto)
	       (s-value inst :s-feedback-obj nil)
	       (s-value inst :p-feedback-obj nil))
	      (setf ignore (get-values proto :do-not-dump-slots))
	      (setf local-state-slots (get-values proto :local-state-slots))
	      (doslots (slot proto) ; for each slot
		       (unless (or (eq slot :is-a)  (member slot ignore))
			 (lapidary::make-slot-in-inst proto inst slot prototypes
					    local-state-slots))))
	  prototypes instances)

    ;; initialize all instances:
    (mapc #'(lambda (proto inst)
;	      (format t "before initialization~%")
;	      (ps inst)
	      (when (g-local-value inst :parent)
		(destroy-slot inst :parent))
	      (kr-send inst :initialize inst)
;	      (format t "after initialization~%")
;	      (ps inst)
	      )
	  prototypes instances)
    (setf result (get-value gadget :my-instance))
    (set-values result :parent nil)

    (dolist (p prototypes) (kr::destroy-slot p :my-instance))
    result))

(defun Make-Window-And-Title ()
  (create-instance 'w inter:interactor-window
				  (:left   *window-left*)
				  (:top    *window-top*)
				  (:width  *window-width*)
				  (:height *window-height*)
				  (:title "Demo-Othello")
				  (:icon-title "Othello"))
  (s-value w :aggregate (create-instance 'top-agg opal:aggregate))
  (opal:update w)
  (create-instance 'title opal:text
	(:string "Garnet Othello")
	(:font title-font))
  (opal:add-component top-agg title)
  (let* ((title-height (g-value title :height))
	 (title-width  (g-value title :width))
	 (title-left   (- *window-center* (half title-width)))
	 (title-right  (+ title-left title-width))
	 (title-frame-left       (- title-left *title-width-offset*))
	 (title-frame-right      (+ title-right *title-width-offset*))
	 (title-frame-mid-height (+ *title-height-offset* (half title-height)))
	 (title-line-right	 (- *window-width* *title-line-x-offset*))
	 (title-line-bottom	 (- *window-height* *title-line-y-offset*)))
	(setq *topmost-box-point* (+ title-height (* 2 *title-height-offset*)))
	(setq *bottommost-box-point*	(- *window-height*
					   (* 2 *title-line-y-offset*)))
	(setq *mat-top*	*topmost-box-point*)
	(setq *board-top*	(+ *mat-top* *board-offset*))
	(setq *mat-bottom*	*bottommost-box-point*)
	(setq *board-bottom*	(- *mat-bottom* *board-offset*))
	(setq *board-height*	(- *board-bottom* *board-top*))
	(s-value title :left title-left)
	(s-value title :top *title-height-offset*)
	(create-instance 'title-line opal:polyline
	  (:point-list
	    (list
		title-frame-left	title-frame-mid-height
		*title-line-x-offset*	title-frame-mid-height
		*title-line-x-offset*	title-line-bottom
		title-line-right	title-line-bottom
		title-line-right	title-frame-mid-height
		title-frame-right	title-frame-mid-height
	    )))
    (opal:add-component top-agg title-line)
    (make-lapidary-usable w))
)

(defun Start-Game ()
  (let ((n (g-value scroll-bar :n))
	(rect-index 0)
	(row-left *board-left*)
	(row-end 0)
	(old-row-end 0)
        (row-width 0)
        col-top col-end old-col-end temp
	active-list
	(piece1-size (min *score-box-piece-width*
			  (g-value player1-text :height)))
	(piece2-size (min *score-box-piece-width*
			  (g-value player2-text :height)))
	(pieces-base-left (+ (* 2 *title-line-x-offset*)
			     *score-box-x-indent*))
	)
    (if *game-started* (Stop-Game))
    (setq *game-started* T)
    (create-instance 'score-box-game-pieces opal:aggregate)
    (setq score-box-piece-1 (make-gadget user::game-piece-1))
    (s-value score-box-piece-1
		:top (g-value player1-text :top))
    (s-value score-box-piece-1
		:left (+ pieces-base-left (half (- *score-box-piece-width*
						    piece1-size))))
    (s-value score-box-piece-1
		:width  piece1-size)
    (s-value score-box-piece-1
		:height piece1-size)
    (setq score-box-piece-2 (make-gadget user::game-piece-2))
    (s-value score-box-piece-2
		:top (g-value player2-text :top))
    (s-value score-box-piece-2
		:left (+ pieces-base-left (half (- *score-box-piece-width*
						    piece2-size))))
    (s-value score-box-piece-2
		:width  piece2-size)
    (s-value score-box-piece-2
		:height piece2-size)
    (opal:add-components score-box-game-pieces score-box-piece-1
					       score-box-piece-2)

    (create-instance 'board opal:aggregate)

		;; These are the 4 rectangles which compose the outside
		;; dark gray region around the board...

    (dolist (rect (list (list *mat-top* *mat-bottom* *mat-left* *board-left*)
			(list *mat-top* *mat-bottom* *board-right* *mat-right*)
			(list *mat-top* *board-top* *board-left* *board-right*)
			(list *board-bottom* *mat-bottom*
					 *board-left* *board-right*)))
	(let ((top  (first rect))
	      (left (third rect)))
	  (opal:add-component board (create-instance NIL opal:rectangle
				(:line-style NIL)
				(:filling-style opal:dark-gray-fill)
				(:left left)
				(:top top)
				(:width (- (fourth rect) left))
				(:height (- (second rect) top))))))
    (create-instance 'outer-square opal:rectangle
				(:left *mat-left*)
				(:top  *mat-top*)
				(:width (- *mat-right* *mat-left*))
				(:height (- *mat-bottom* *mat-top*)))
    (opal:add-component board outer-square)
    (s-value board :n n)

		;; Now we must create the N x N squares...
    (dotimes (row n)
      (incf row-left row-width)
      (setq old-row-end row-end)
      (setq row-end (floor (* (/ (1+ row) n) *board-width*)))
      (setq row-width (- row-end old-row-end))
      (setq col-top *board-top*)
      (setq old-col-end (setq col-end 0))
      (dotimes (col n)
        (incf col-top (- col-end old-col-end))
	(setq old-col-end col-end)
        (setq col-end (floor (* (/ (1+ col) n) *board-height*)))
	(setq temp (aref *rectangles* rect-index))
	(push temp active-list)
	(incf rect-index 1)
	(s-value temp :left row-left)
	(s-value temp :width row-width)
	(s-value temp :top col-top)
	(s-value temp :height (- col-end old-col-end))
	(s-value temp :row row)
	(s-value temp :column col)
	(s-value temp :player NIL)
	(s-value temp :visible T)
	(setf (aref board-array row col) temp)))
    (s-value squares :active-list active-list)

		;; Set all the remaining rectangles to be invisible
    (do ((x rect-index (1+ x)))
	((>= x *rect-count*))
	(s-value (aref *rectangles* x) :visible NIL))

    (opal:add-component board squares :front)

    (let* ((hi-square (/ n 2))
	   (lo-square (1- hi-square)))
	(Make-Game-Piece-Pair lo-square lo-square 1)
	(Make-Game-Piece-Pair hi-square hi-square 1)
	(Make-Game-Piece-Pair lo-square hi-square 2)
	(Make-Game-Piece-Pair hi-square lo-square 2))

    (s-value message :string "Player 1's move")
    (setq *current-player* 1)
    (setq *other-player* 2)
    (setq *scores* (make-array 3))
    (setf (aref *scores* 1) 2)
    (setf (aref *scores* 2) 2)
    (set-scores)
    (opal:add-components top-agg board score-box-game-pieces)

    (create-instance 'board-inter inter:button-interactor
		(:start-where `(:list-element-of ,squares :active-list))
		(:window w)
		(:stop-action #'process-button-press))

    ;; For some reason, if we don't include this, the update takes forever!
    (opal:update w T)
  )
)
