;;; ENGLISH: Site specific definitions, to be modified on installation
;;; DEUTSCH: Funktionen, die beim Transportieren zu ndern sind

(in-package "LISP")
(mapcar #'fmakunbound '(short-site-name long-site-name edit-file))

(defun short-site-name () "Karlsruhe")
(defun long-site-name () "Augartenstrae 40, D-W7500 Karlsruhe 1, Deutschland")

;; ENGLISH: The name of the editor:
;; DEUTSCH: Der Name des Editors:
(defparameter *editor* "vi")

;; ENGLISH: (edit-file file) edits a file.
;; DEUTSCH: (edit-file file) editiert eine Datei.
(defun edit-file (file)
  (shell (format nil "~A ~A" *editor* (truename file)))
)

;; ENGLISH: The temporary file LISP creates for editing:
;; DEUTSCH: Das temporre File, das LISP beim Editieren anlegt:
(defparameter tempfile "/tmp/lisptemp.lsp")

;; ENGLISH: The list of directories where programs are searched on LOAD etc.:
;; DEUTSCH: Die Liste von Directories, in denen Programme bei LOAD etc. gesucht
;;          werden:
(defparameter *load-paths* '(#"./" #"./**/" #"~/**/"))

