;;; ENGLISH: Site specific definitions, to be modified on installation
;;; DEUTSCH: Funktionen, die beim Transportieren zu ndern sind

(in-package "LISP")
(mapcar #'fmakunbound '(short-site-name long-site-name edit-file))

(defun short-site-name () "Uni Karlsruhe")
(defun long-site-name () "Mathematisches Institut II, Universitt Karlsruhe, Englerstrae 2, D - W 7500 Karlsruhe 1")

;; ENGLISH: The name of the editor:
;; DEUTSCH: Der Name des Editors:
(defparameter *editor* "vi")

;; ENGLISH: (edit-file file) edits a file.
;; DEUTSCH: (edit-file file) editiert eine Datei.
(defun edit-file (file)
  (shell
    (format nil "~A ~A"
                (if (sys::getenv "WINDOW_PARENT") ; Suntools aktiv?
                  "textedit"
                  (or (sys::getenv "EDITOR") ; Benutzer-Prferenz?
                      *editor*               ; sonst: Default-Editor
                ) )
                (truename file)
) ) )

;; ENGLISH: The temporary file LISP creates for editing:
;; DEUTSCH: Das temporre File, das LISP beim Editieren anlegt:
(defparameter tempfile "/tmp/lisptemp.lsp")

;; ENGLISH: The list of directories where programs are searched on LOAD etc.:
;; DEUTSCH: Die Liste von Directories, in denen Programme bei LOAD etc. gesucht
;;          werden:
(defparameter *load-paths* '(#"./" #"./**/" #"~/**/"))

