.cL \&Semaphore \&Object "Process Synchronization Class"

.vM
.LI "\&LinkedList waitlist"
list of \&Process\&es waiting on this \&Semaphore
.LI "short count"
number of \&Process\&es waiting on this \&Semaphore
.LE

.vP
.LI none
.LE

.DS
.I Description:
.DE
Class \&Semaphore provides a mechanism for synchronizing processes.
.P
The following functions, inherited from class \&Object, are disabled
in class \&Semaphore by defining them as
.C should\%Not\%Implement() :
.DS I F
.C
shallowCopy()
.R
.DE

.DS
.I Functions:
.DE
.fM  (constructor) \&Semaphore "(int initialCount =0)" "construct \&Semaphore"
Constructs an instance of a \&Semaphore with the specified
.I initialCount .
An
.I initialCount
of 0 is useful for a \&Semaphore used to suspend a \&Process until a signal or AST
occurs, and an
.I initialCount
of 1 is useful for a \&Semaphore used to achieve mutual exclusion for a critical
region.
.fE

.fV  void deepenShallowCopy "()" "convert shallow copy of \&Semaphore to deep copy"
Converts this shallow copy to a deep copy.  If processes are waiting on this \&Semaphore a
.C CPSEMWAIT
error results.
.fE

.fV  int hash "()" "\&Semaphore hash"
Returns a number suitable for a hash table probe.
.C Semaphore::hash()
is implemented as
.C
{ return (int)this; }.
.R
.fE

.fV  "const \&Class*" isA "()" "pointer to \&Semaphore class descriptor"
Returns a pointer to the \&Semaphore class descriptor,
.C class_Semaphore .
.fE

.fV  bool isEqual "(const \&Object& ob)" "test \&Semaphore\&s equal"
Returns
.C YES
if this \&Semaphore is the same (i.e.,
.C isSame() )
as
.I ob .
.fE

.fV  void printOn "(ostream& strm)" "print \&Semaphore on output stream"
Prints the count and list of processes waiting for this \&Semaphore on output stream
.I strm .
.fE

.fV  void signal "()" "send signal to \&Semaphore"
If the value of
.I count
for this \&Semaphore is <\ 0 then the first waiting \&Process is resumed.
The value of
.I count
is unconditionally incremented.
.fE

.fV  void storer "(ostream& strm)" "store \&Semaphore on output stream"
Stores this \&Semaphore on output stream
.I strm .
If processes are waiting on this \&Semaphore a
.C STSEMWAIT
error results.
.fE

.fV  int value "()" "read \&Semaphore count"
Returns the current value of this \&Semaphore's
.I count .
.fE

.fV  void wait "()" "\&Process wait on \&Semaphore"
Decrements the value of
.I count
for this \&Semaphore, and if
.I count
<0 suspends the currently active \&Process and places it at the end of this \&Semaphore's
.I waitList ,
then calls the scheduler to run the highest priority runnable \&Process.
.C wait()
must not be called from a signal or AST routine.
.fE
