#ifndef	RANDOM_H
#define	RANDOM_H

/*$Header: Random.h,v 2.204 89/10/07 23:21:07 keith Stab $*/

/* Random.h -- declarations for pseudo-random number generator

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Random.h,v $
 * Revision 2.204  89/10/07  23:21:07  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:48  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:36  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:34  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:16:27  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:04  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:43:38  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:19:50  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:00:34  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:09:36  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:17:26  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:48  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:20  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 */

#include "Object.h"

class Random: public VIRTUAL Object {
	DECLARE_MEMBERS(Random);
	long	s1,s2;
	void checkSeeds();
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Random();
	Random(long seed1, long seed2);
	float next();
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
