/* KeySortCltn.c  -- implementation of class KeySortCltn

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	S. M. Orlow
	Systex Inc.
	Beltsville, MD 20705

Contractor:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	February, 1987

Function:
	
Modification History:

$Log:	KeySortCltn.c,v $
 * Revision 2.204  89/10/07  23:19:58  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/22  17:27:47  keith
 * Pre-release
 * 
 * Revision 2.202.1.4  89/08/22  17:26:49  keith
 * Change to operate on LookupKey instead of Assoc.
 * 
 * Revision 2.202.1.3  89/07/08  19:11:48  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.2  89/07/03  15:51:07  keith
 * Replace explicit use of Iterator with DO ... OD.
 * 
 * Revision 2.202.1.1  89/07/01  21:54:36  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:29  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  20:49:21  keith
 * Comment BUG_TOOBIG code.
 * 
 * Revision 2.201.1.3  89/06/22  10:14:30  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  23:05:32  keith
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:57:43  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:17:53  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:59:09  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:39  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:06  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:32  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "nihclIO.h"
#include "Assoc.h"
#include "KeySortCltn.h"

#define	THIS	KeySortCltn
#define	BASE	SortedCltn
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(KeySortCltn,1,"$Header: KeySortCltn.c,v 2.204 89/10/07 23:19:58 keith Stab $",NULL,NULL);

KeySortCltn::KeySortCltn(int size) : BASE(size) {}

#ifndef BUG_TOOBIG
// yacc stack overflow
KeySortCltn::KeySortCltn(const KeySortCltn& c) : BASE(c) {}
#endif

LookupKey* KeySortCltn::assocAt(int i)
{
	return LookupKey::castdown(at(i));
}

Object* KeySortCltn::keyAt(int i)
{
	LookupKey& assoc = *assocAt(i);
	return assoc.key();
}

Object* KeySortCltn::valueAt(int i)
{
	LookupKey& assoc = *assocAt(i);
	return assoc.value();
}

Object* KeySortCltn::atKey(Object& key)
{
	// binary search for key
	int i = findIndexOf(key);

	if (i > -1 && key.compare(*keyAt(i)) == 0)
		return valueAt(i);
	else 
		return nil; // key not found
}

Assoc* KeySortCltn::addAssoc(Object& key, Object& val)
{
	Assoc* assoc = new Assoc(key,val);
	SortedCltn::add(*assoc);
	return assoc;
}

Collection& KeySortCltn::addValuesTo(Collection& c) const
{
	DO(*this,LookupKey,as) c.add(*(as->value())); OD
	return c;
}

Collection& KeySortCltn::addKeysTo(Collection& c) const
{
	DO(*this,LookupKey,as) c.add(*(as->key())); OD
	return c;
}

Collection& KeySortCltn::addContentsBeforeTo(Object& key,Collection& c)
{
	if (isEmpty()) return c;
	int k = findIndexOf(key);
	if (k<0) return c;
	for (int i=0; i<=k; i++ )
		c.add(*at(i));
	return c;
}

void KeySortCltn::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
}

int KeySortCltn::occurrencesOfKey(const Object& key) const
{
	return SortedCltn::occurrencesOf(LookupKey((Object&)key));
}

bool KeySortCltn::includesKey(Object& key) const
{
	return occurrencesOfKey(key) > 0;
}

Object* KeySortCltn::removeKey(Object& key) { return SortedCltn::remove(LookupKey(key)); }

int KeySortCltn::findIndexOf(Object& key) const
/*
	if key is found return index of key
	else if key is before all keys return -1
		else return index of last key before given key
*/
{
	return SortedCltn::findIndexOf(LookupKey(key));
}

Range KeySortCltn::findRangeOfKey(Object& key) const
{
	return SortedCltn::findRangeOf(LookupKey(key));
}

KeySortCltn::KeySortCltn(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
}

KeySortCltn::KeySortCltn(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)

{
}
