//  AutoDeriv.c -- one dimensional automatic derivative

// $Header: AutoDeriv.c,v 2.204 89/10/08 14:38:39 keith Stab $
/*
Author:
    S.M.Orlow
    Systex, Inc.
    Beltsville, MD 20705
    301-474-0111
    sandy@alw.nih.gov
*/

#include <iostream.h>
#include "AutoDeriv.h"

void AutoDeriv::operator=(const AutoDeriv& x) 
{
    u=F(x); du=dF(x);
}
int AutoDeriv::operator==(const AutoDeriv& x) const
{
    return (u==F(x)&&du==dF(x));
}

AutoDeriv AutoDeriv::operator-() const
{
    return AutoDeriv(-u,-du);
}

AutoDeriv AutoDeriv::pow(int k) const
{
    if ( k==0 )  return AutoDeriv(1,0);
   else if ( k==1 )  return *this;
   else if ( k>1 )   return (*this)*(this->pow(k-1));
   else    /*k<0*/   return AutoDeriv(1,0)/this->pow(-k);
}

void AutoDeriv::printOn(ostream& strm) const
{
    strm << "[" << u << "," << du << "]";
}
ostream& operator<<(ostream& strm, const AutoDeriv& x)
{
    x.printOn(strm);
    return strm;
}
