// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "LockedFifo.h"
#include "stream.h"

LockedFifo::LockedFifo(int defaultLength)
  : (defaultLength), fifoLock(1)
{
    //
    // do nothing
    //
}

void
LockedFifo::add(AwesimeFifoItem* t)
{
    fifoLock.reserve();
    AwesimeFifo::add(t);
    fifoLock.release();
}

bool
LockedFifo::remove(AwesimeFifoItem *t)
{
    fifoLock.reserve();
    bool ok = AwesimeFifo::remove(t);
    fifoLock.release();
    return(ok);
}

bool
LockedFifo::removeIfFound(AwesimeFifoItem *t)
{
    fifoLock.reserve();
    bool ok = AwesimeFifo::removeIfFound(t);
    fifoLock.release();
    return(ok);
}

bool
LockedFifo::doStart(AwesimeFifoIndex &index, AwesimeFifoItem* item)
{
    fifoLock.reserve();
    return( AwesimeFifo::doStart(index, item) );
}

void
LockedFifo::doDone()
{
    fifoLock.release();
}

unsigned int
LockedFifo::size()
{
    fifoLock.reserve();
    unsigned int s = AwesimeFifo::size();
    fifoLock.release();
    return(s);
}


void LockedFifo::classPrintOn(ostream& s)
{
    fifoLock.reserve();
    AwesimeFifo::classPrintOn(s);
    fifoLock.release();
}
