// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "Event.h"
#include "CpuMultiplexor.h"
#include "CpuMultiplexorP.h"
#include "Thread.h"

Event::~Event()
{
    lock.reserve();
    assert( pPileOfThreads.isEmpty() );
    lock.release();
}

void
Event::releaseAll()
{
    while ( ! pPileOfThreads.isEmpty() ) {
	Thread *p = (Thread *) (pPileOfThreads.remove());
	ThisCpu -> add(p);
    }
}

void
Event::trigger()
{
    lock.reserve();
    generation++;
    releaseAll();
    lock.release();
}

void
Event::waitFor()
{
    lock.reserve();
    int gen = generation;
    lock.release();

    for (int i = 0; i < pLoops; i++) {
	if (gen != generation) break;
    }

    if (gen == generation) {
	ThisCpu -> reserveByException( this );
    }
}

int
Event::reserveByException(Thread *byWho)
{
    lock.reserve();
    pPileOfThreads.add( byWho );
    lock.release();
    return(TRUE);
}

int
Event::size()
{
    lock.reserve();
    int s = pPileOfThreads.size();
    lock.release();
    return(s);
}

