/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _dfsnum.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



/*******************************************************************************
*                                                                              *
*  DFS_NUM (depth first search numbering)                                      *
*                                                                              *
*******************************************************************************/


#include <LEDA/graph_alg.h>

int dfs_count1,dfs_count2;

void d_f_s(node v, node_array(bool)& S, node_array(int)& dfsnum, 
                                        node_array(int)& compnum,
                                        list(edge)& T )
{ node w;
  edge e;

  S[v] = true;
  dfsnum[v] = ++dfs_count1;

  forall_adj_edges(e,v) 
    { w = target(e);
      if (!S[w]) 
       { T.append(e);
         d_f_s(w,S,dfsnum,compnum,T);
        }
     }

  compnum[v] = ++dfs_count2;
} 

list(edge) DFS_NUM(const graph& G, node_array(int)& dfsnum, 
                                   node_array(int)& compnum)
{ 
  list(edge) T;
  node_array(bool) reached(G,false);
  node v;
  dfs_count1 = dfs_count2 = 0;
  forall_nodes(v,G) if (!reached[v]) d_f_s(v,reached,dfsnum,compnum,T);
  return T;
}

