#include <LEDA/graph.h>
#include <LEDA/graph_alg.h>


declare2(GRAPH,int,int);

void main()
{

GRAPH(int,int) G;
edge e;

test_graph(G);

edge_array(int)  cap(G,0);
edge_array(int)  flow(G,0);

int a = read_int("a = ");
int b = read_int("b = ");

forall_edges(e,G) G[e] = cap[e] = random(a,b);

node s = G.first_node();
node t = G.last_node();

float T = used_time();

cout << "MAX_FLOW (int)    ";
cout.flush();
int val = MAX_FLOW(G,s,t,cap,flow) ;
cout << string("flow = %d     time: %6.2f sec  \n",val,used_time(T));
newline;



#ifndef __TURBOC__

edge_array(double)  cap1(G,0);
edge_array(double)  flow1(G,0);

forall_edges(e,G) cap1[e] = cap[e];

cout << "MAX_FLOW (doubles)  ";
cout.flush();
double val1 = MAX_FLOW(G,s,t,cap1,flow1);
cout << string("flow = %f     time: %6.2f sec  \n",val1,used_time(T));
newline;


if (Yes("show flow values? "))
forall_edges(e,G) 
  { G.print_edge(e);
    cout << string(" flow = %6d  flow1 = %4.2f\n",flow[e],flow1[e]);
  }
newline;

#endif


}


