/* 
   Example for parameterized types:

   Arrays of lists of 3-dim points

 */


#include <LEDA/list.h>
#include <LEDA/array.h>


   class d3_point
   {
      double x;
      double y;
      double z;


      public:

      d3_point() { x = y = z = 0; }
   

      friend istream& operator>>(istream& I, d3_point& p)
      { return I >> p.x >> p.y >> p.z;}

      friend ostream& operator<<(ostream& O, const d3_point& p)
      { return O << "(" << p.x << "," << p.y << "," << p.z << ")"; }


      friend int compare(const d3_point& p, const d3_point& q)  // lexicograph.
      { int b;
        if (b=compare(p.x,q.x)) 
           return b;
        else 
           if (b=compare(p.y,q.y)) 
              return b;
           else 
              if (b=compare(p.z,q.z)) 
                 return b;
              else 
                 return 0;
       }


    };


    LEDA_TYPE_PARAMETER(d3_point)

    declare(list,d3_point)


    inline istream& operator>>(istream& I, list(d3_point)& L)  
    { L.read(I); return I;}

    inline ostream& operator<<(ostream& O, const list(d3_point)& L)  
    { L.print(O); return O;}

    inline int compare(const list(d3_point)& L1, const list(d3_point)& L2)
    { return compare(L1.head(),L2.head()); }  // compare first element


    LEDA_TYPE_PARAMETER(list(d3_point))

    declare(array,list(d3_point))


    main()
    {
       array(list(d3_point)) A(1,5);
       int i;

       for(i=1;i<=5;i++) A[i].read(string("List[%d]: ",i));
       newline;

       A.print("input:",'\n');
       newline;
       newline;

       for(i=1;i<=5;i++) A[i].permute();
       A.permute();

       A.print("permuted:",'\n');
       newline;
       newline;

       for(i=1;i<=5;i++) A[i].sort();
       A.sort();

       A.print("sorted:",'\n');
       newline;
       newline;

     }
