#include <LEDA/dictionary1.h>

typedef int DIC_item;

class DIC {

private:

virtual int  cmp(const GenPtr&, const GenPtr&) const =0;
virtual void clear_key(GenPtr&) const   =0;
virtual void clear_inf(GenPtr&) const   =0;
virtual void copy_key(GenPtr&)  const   =0;
virtual void copy_inf(GenPtr&)  const   =0;


// simple example implementation by two arrays

GenPtr K[1024];
GenPtr I[1024];
int    count;


public:

 DIC();
 DIC(const DIC&);
~DIC();

DIC& operator=(const DIC&);

GenPtr key(DIC_item p)  const;
GenPtr inf(DIC_item p)  const;

DIC_item  insert(GenPtr,GenPtr);
DIC_item  lookup(GenPtr)  const;
DIC_item  first_item() const;
DIC_item  next_item(DIC_item) const;

void    change_inf(DIC_item,GenPtr);
void    del_item(DIC_item);
void    del(GenPtr);
void    clear();

int     size()        const;

};



// array implementation


inline DIC::DIC() { count = 0; };

inline int       DIC::size() const                { return count; }
inline GenPtr    DIC::key(DIC_item i)  const      { return K[i]; }
inline GenPtr    DIC::inf(DIC_item i)  const      { return I[i]; }
inline DIC_item  DIC::first_item() const          { return (0>=count) ? 0:1; }
inline DIC_item  DIC::next_item(DIC_item i) const { return (i>=count) ? 0:i+1;}


DIC::DIC(const DIC& D) 
{ for(int i=1; i<=D.count; i++) 
  { K[i] = D.K[i];
    I[i] = D.I[i];
    D.copy_key(K[i]);
    D.copy_inf(I[i]);
   }
  count = D.count;
 }


DIC::~DIC()
{ for(int i=1; i<=count; i++) 
  { clear_key(K[i]);
    clear_inf(I[i]);
   }
}


DIC& DIC::operator=(const DIC& D)
{ for(int i=1; i<=D.count; i++) 
  { K[i] = D.K[i];
    I[i] = D.I[i];
    copy_key(K[i]);
    copy_inf(I[i]);
   }
  count = D.count;
  return *this;
 }


DIC_item  DIC::insert(GenPtr key, GenPtr inf) 
{  DIC_item i = lookup(key);
   if (i != nil)
     { clear_key(K[i]);
       copy_inf(inf);
       K[i] = inf;
       return i;
      }
   else
     { copy_key(key);
       copy_inf(inf);
       count++;
       K[count] = key;
       I[count] = inf;
       return count;
      }
}


DIC_item  DIC::lookup(GenPtr key)  const
{ for(DIC_item i=1; i<=count && K[i] != key;i++);
  if (i>count) return nil;
 }



void    DIC::change_inf(DIC_item i, GenPtr inf)
{ clear_inf(I[i]);
  copy_inf(inf);
  I[i] = inf;
 }

void    DIC::del_item(DIC_item i)
{ clear_key(K[i]);
  clear_inf(I[i]);
  K[i] = K[count];
  I[i] = I[count];
  count--;
}

void    DIC::del(GenPtr key)
{ DIC_item i = lookup(key);
  if (i!=nil) del_item(i);
 }

void    DIC::clear() 
{ for(int i=1; i<=count; i++)
  { clear_key(K[i]);
    clear_inf(I[i]);
   }
  count = 0;
 }




declare2(dictionary,int,int)

declare3(DICTIONARY,int,int,DIC)


void main() 
{ 
  DICTIONARY(int,int,DIC) D; 
  dic_item it;
  int i;

  for(i=0; i<10; i++) D.insert(i,i);

  forall_items(it,D) cout << D.key(it) << "  " << D.inf(it) << "\n";

 }

