/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.


 */

// The "#pragma defmacro" is a COOL extension to the standard  ANSI C processor
// that allows  a programmer to  define macro  extensions to the  language. All
// COOL  macros   have  been  incorporated  into  the preprocessor   itself  to
// facilitate extra speed and efficiency. User defined  extensions are searched
// for on the include file path.

#pragma defmacro MACRO "macro" delimiter=} recursive
#pragma defmacro template "template" delimiter=}
#pragma defmacro DECLARE "declare" delimiter=> recursive lines
#pragma defmacro IMPLEMENT "implement" delimiter=> recursive lines

extern void* error (char*);

template<class T> class Vector<T> {
	T* v;
	int sz;
public:
	Vector<T>(int);
	T& operator[](int);
	inline T& elem(int i) { return v[i]; }
};

template<class T>
T& Vector<T>::operator[](int i)
{
	if (i<0 || sz<=i) error("vector: range error");
	return elem(i);
};

template<class T>
Vector<T>::Vector<T>(size)
{
	v = new(T[size]);
};

DECLARE Vector<char*>;   // create definitions for a vector of strings
IMPLEMENT Vector<char*>; // generate code to support vector of strings
Vector<char*> vs(30);	 // declare a vector of 30 strings
