//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// test file for the class, MACRO, and Template defmacros
//

#pragma defmacro MACRO "macro" delimiter=} recursive
#pragma defmacro class "class"
#pragma defmacro classmac "classmac" delimiter=)

// tell the class macro to call the generate_slot_accessors macro inside
// the class definition.  There will be a call to the slot_accessor macro
// in the body arg to generate_slot_accessors for each slot in the class.
classmac (generate_slot_accessors, inside, slots=slot_accessor)

// Invoked from the class macro
MACRO generate_slot_accessors (class_name, base_class, BODY: methods) {
 methods }

// expanded within my_generate_methods
MACRO slot_accessor (type, name, value) {
  const type& get_##name() { return name }
}

class foo: virtual public Generic {
 private:
  int* data;				// Pointer to allocated storage
  char *a, *b, c;			// Three miscellaneous variables
  int size;				// Size of foo object
  void grow (int new_size);		// Private function to grow foo
 public:
  foo (int);				// Constructor with size
  ~foo (){};				// Destructor 
  int& operator[] (int);		// Operator[] overload for Type
  Boolean find (const int&);		// Find element in foo
  // ..
};
