//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/misc.h>

#if defined(DOS) || defined(M_XENIX)
#include <stream.hxx>
#else
#include <stream.h>
#endif

#pragma defmacro class "class"
#pragma defmacro classmac "classmac" delimiter=)

classmac (generate_slot_accessors, inside, slots=slot_accessor)

MACRO generate_slot_accessors (class_name, base_class, BODY: methods) {
  methods }

MACRO slot_accessor (type, name, value) {
  const type& get_##name() { return name; }
  void set_##name(type& new_value) { name = new_value; }
}

class foo {
private:
  int* data;			// Pointer to allocated storage
  char *a, *b, *c;		// Three miscellaneous variables
  int size;			// Size of foo object
  void grow (int new_size);	// Private function to grow foo
public:
  foo (int);			// Constructor with size
  ~foo () {};			// Destructor 
  int& operator[] (int);	// Operator[] overload for Type
  Boolean find (const int&);	// Find element in foo
};

foo::foo (int n) {
  this->data = (int*) new int[n];
  this->size = n;
}

Boolean foo::find (const int& value) {
  register int i;
  for (i = 0; i < this->size; i++)
     if (this->data[i] == value) return TRUE;
  return FALSE;
}

int& foo::operator[] (int n) {
  if (n < size)  return this->data[n];
}

int main (void) {
  foo f(1);
  char* x = "x";
  char* y = "y";
  char* z = "z";
  f[0] = 11;
  f.set_a(x);
  f.set_b(y);
  f.set_c(z);
  cout << "f.get_a() is " << f.get_a() << "\n";
  cout << "f.get_b() is " << f.get_b() << "\n";
  cout << "f.get_c() is " << f.get_c() << "\n";
  return (0);
}
