//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Created: LGO 10/12/89 -- re-wrote to access slots directly for Cfront 2.0
//

#include <cool/Generic.h>
#include <cool/Properties.h>

// operator<< -- Overload the output operator to provide a formatted output
//               capability for Symbol object
// Input:        Ostream reference, Symbol pointer
// Output:       Reference to ostream object

ostream& operator<< (ostream& os, const Symbol& s) {
  os << s.pname;				// Output symbol name
  if(s.val != NULL)				// If there is a value
    os << " " << s.val;				// Output symbol value
  if(s.proplist != NULL)			// If there are properties
    os << " " << *s.proplist;			// Output property list
  return os;					// Return refererence to stream
}

ostream& operator<< (ostream& os, const Symbol* s) {
  return operator<<(os, *s);
}
