//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/List.h>
#include <cool/Vector.h>
#include <test.h>

DECLARE List<int>;

DECLARE List<double>;

DECLARE List<char*>;

DECLARE List<char>;

DECLARE Vector<int>;

DECLARE List<Vector<int>>;
IMPLEMENT List<Vector<int>>;

DECLARE List<Vector<int>*>;
IMPLEMENT List<Vector<int>*>;

DECLARE List<List<int>>;
IMPLEMENT List<List<int>>;

DECLARE List<List<int>*>;
IMPLEMENT List<List<int>*>;

DECLARE List<Generic*>;
IMPLEMENT List<Generic*>;

// *********************
// List of doubles tests
// *********************

int my_compare_double(const double& t1, const double& t2) {
  return ((t1 < t2) ? -1 : 1);
}

void list_double_op_test1() {

  List<double> ltemp1;
  List<double> ltemp2;

  // List l0 is ().
  List<double> l0;
  TEST("List<double> l0", 1, 1);

  // List l4(3,1.0,2.0,3.0) is (1.0 2.0 3.0).
  List<double> l4(3,1.0,2.0,3.0);
  TEST("List<double> l4(3,1.0,2.0,3.0)", 1, 1);

  // List l5(l4) is (1.0 2.0 3.0).
  List<double> l5(l4);
  TEST("List<double> l5(l4)", 1, 1);

  TEST("l5[2]", l5[2]==3.0 && l5.value()==3.0, TRUE);
//  TEST("l5[-1]", l5[-1], ERROR);
//  TEST("l5[3]", l5[3], ERROR);
  TEST("l5.get(1)", l5.get(1)==2.0, TRUE);
//  l5[1]=43.0;
  TEST_RUN("l5[1]=43.0", l5[1]=43.0, l5[1]==43.0, TRUE);
  TEST_RUN("l5.put(55.0,1)", l5.put(55.0,1), l5.get(1)==55.0, TRUE);
  // l5 is (1 55 3);
  TEST_RUN("l5.tail(ltemp1)", l5.tail(ltemp1),
       (ltemp1.length()==2 && ltemp1[0]==55.0 && ltemp1[1]==3.0), TRUE);
  TEST_RUN("l5.tail(ltemp1,0)", l5.tail(ltemp1,0),
	   (ltemp1.length()==3 && ltemp1[0]==1.0 && ltemp1[1]==55.0
	    && ltemp1[2]==3.0),
       TRUE);
  TEST_RUN("l5.tail(ltemp1,3)", l5.tail(ltemp1,3), ltemp1.is_empty(), TRUE);
  TEST_RUN("l5.tail(ltemp1,5)", l5.tail(ltemp1,5), ltemp1.is_empty(), TRUE);

  // l5 is (1 55 3);
  TEST_RUN("l5.last(ltemp1,0)", l5.last(ltemp1,0), ltemp1.is_empty(), TRUE);
  TEST_RUN("l5.last(ltemp1)", l5.last(ltemp1), 
	   (ltemp1.length()==1 && ltemp1[0]==3.0), TRUE);
  TEST_RUN("l5.last(ltemp1,2)", l5.last(ltemp1,2),
	   (ltemp1.length()==2 && ltemp1[0]==55.0 && ltemp1[1]==3.0),
	   TRUE);
  TEST_RUN("l5.last(ltemp1,3)", l5.last(ltemp1,3),
	   (ltemp1.length()==3 && ltemp1[0]==1.0 && ltemp1[1]==55.0
	    && ltemp1[2]==3.0),
	   TRUE);
  TEST_RUN("l5.last(ltemp1,5)", l5.last(ltemp1,5), ltemp1.is_empty(), TRUE);

}

void list_double_op_test2() {

  List<double> ltemp1;
  List<double> ltemp2;

  // List l1(3.0) is (3.0).
  List<double> l1(3.0);
  TEST("List<double> l1(3.0)", 1, 1);

  // List l2(2.0,l1) is (2.0 3.0).
  List<double> l2(2.0,l1);
  TEST("List<double> l2(2.0,l1)", 1, 1);

  // List l3(1.0,l2) is (1.0 2.0 3.0).
  List<double> l3(1.0,l2);
  TEST("List<double> l3(1.0,l2)", 1, 1);

  // List l4(3,1.0,2.0,3.0) is (1.0 2.0 3.0).
  List<double> l4(3,1.0,2.0,3.0);
  TEST("List<double> l4(3,1.0,2.0,3.0)", 1, 1);

  TEST("l3 == l4", l3==l4, TRUE);

  ltemp1 = List<double>(4,11.0,22.0,33.0,44.0);
  List<double> l6;
  
  TEST_RUN("l6.but_last(ltemp2, 0)", ltemp1.copy(l6); l6.but_last(ltemp2, 0),
	   (ltemp2.length()==4 && ltemp2[0]==11.0 && ltemp2[1]==22.0
	    && ltemp2[2]==33.0 && ltemp2[3]==44.0),
	   TRUE);
  
  // l6 is (11 22 33 44)
  TEST_RUN("l6.but_last(ltemp2)", l6.but_last(ltemp2),
	   (ltemp2.length()==3 && ltemp2[0]==11.0 && ltemp2[1]==22.0
	    && ltemp2[2]==33.0),
	   TRUE);
  TEST_RUN("l6.but_last(ltemps2, 2)", l6.but_last(ltemp2, 2),
	   (ltemp2.length()==2 && ltemp2[0]==11.0 && ltemp2[1]==22.0),
	   TRUE);
  TEST_RUN("l6.but_last(ltemp2, 4)", l6.but_last(ltemp2, 4), 
	   (ltemp2.length()==0), TRUE);
  TEST_RUN("l6.but_last(ltemp2, 5)", l6.but_last(ltemp2, 5), 
	   (ltemp2.length()==0), TRUE);

  // l6 is now ()
  TEST_RUN("l6.clear()", l6.clear(), (l6.length()==0), TRUE);

  TEST("l6.is_empty()", l6.is_empty(), TRUE);  // l6 is ();
  TEST("l2.is_empty()", l2.is_empty(), FALSE); // l2 is (2 3)

  TEST("l6.length()", l6.length()==0, TRUE);   // l6 is ()
  TEST("l3.length()", l3.length()== 3, TRUE);  // l3 is (1 2 3)

  // l6 is (11 22 33 44)
  TEST_RUN("l6.position(33.0)", ltemp1.copy(l6),
	   (l6.position(33.0)==2 && l6.value()==33.0), TRUE);
  TEST("l6.position(2.0)", l6.position(2.0)==-1, TRUE);
}

void list_double_op_test3() {

  double temp;
  List<double> ltemp1;
  List<double> ltemp2;
  
  List<double> l0;			  // List l0 is ().
  List<double> l1(3.0);			  // List l1 is (3.0).
  List<double> l2(2.0,l1);		  // List l2 is (2.0 3.0).
  List<double> l3(1.0,l2);		  // List l3 is (1.0 2.0 3.0).
  List<double> l4(3,1.0,55.0,3.0);	  // List l4 is (1.0 55.0 3.0).
  List<double> l5(l4);			  // List l5 is (1.0 2.0 3.0).
  List<double> l6(4,11.0,22.0,33.0,44.0); // List l6 is (11.0 22.0 33.0 44.0).
  List<double> l9;

  TEST_RUN("l4.copy(l9)", l4.copy(l9), (l4==l9), TRUE);
  TEST_RUN("l9 = l4", l9 = l4, (l4==l9), TRUE);

  // l6 is (11 22 33 44)
  ltemp1 = List<double>(4,44.0,33.0,22.0,11.0);
  TEST_RUN("l6.reverse()", l6.reverse(), (l6==ltemp1), TRUE);

  // l6 is (44 33 22 11)
  TEST_RUN("l6.push_end(66.0)", l6.push_end(66.0),
	   (l6.length()==5 && l6[4]==66.0 && l6.value()==66.0),
	   TRUE);
  TEST_RUN("l6.push(77.0)", l6.push(77.0),
	   (l6.length()==6 && l6[0]==77.0 && l6.value()==77.0),
	   TRUE);
  TEST_RUN("l6.push_new(88.0)", l6.push_new(88.0),
	   (l6.length()==7 && l6[0]==88.0 && l6.value()==88.0),
	   TRUE);
  TEST_RUN("l6.push_new(22.0)", l6.push_new(22.0),
	   (l6.length()==7 && l6[0]==88.0), TRUE);
  TEST("l6.pop()", (l6.pop(temp), temp), 88);

  // l6 is (77 44 33 22 11 66)
  // l2 is (2 3)
  // l4 is (1 55 3)

  // l6 is now (77 44 33 22 11 66 2 3)
  TEST_RUN("l6.append(l2)", l6.append(l2),
	   (l6.value()==2.0 && l6.length()==8 && l6[6]==2.0 && l6[7]==3.0),
	   TRUE);

  // l6 is now (1 55 3 77 44 33 22 11 66 2 3)
  TEST_RUN("l6.prepend(l4)", l6.prepend(l4),
	   (l6.value()==1.0 && l6.length()==11 && l6[0]==1.0 && l6[1]==55.0
	    && l6[2]==3.0),
	   TRUE);

  TEST_RUN("l6.set_tail(l2, 14)", l6.copy(ltemp1); l6.set_tail(l2,14),
	   l6==ltemp1, TRUE);
  ltemp2 = List<double>(6,1.0,55.0,3.0,77.0,2.0,3.0);
  TEST_RUN("l6.set_tail(l2,4)", l6.set_tail(l2,4), 
	   (l6==ltemp2 && l6.value()==2.0), TRUE);
  TEST_RUN("l6.set_tail(l2)", l6.set_tail(l2),
	   (l6.value()==2.0 && l6.length()==3 && l6[0]==1.0 && l6[1]==2.0
	    && l6[2]==3.0),
	   TRUE);
  TEST_RUN("l6.set_tail(l2,0)", l6.set_tail(l2,0),
	   (l6.value()==2.0 && l6.length()==2 && l6[0]==2.0 && l6[1]==3.0),
	   TRUE);
}

void list_double_op_test4() {

  List<double> ltemp1;
  List<double> ltemp2;
  List<double> l8(5,11.0,22.0,33.0,44.0,55.0);
  List<double> l11(7,11.0,22.0,33.0,11.0,22.0,33.0,44.0);
  
  ltemp1 = List<double>(4,44.0,33.0,22.0,11.0);

  ltemp2 = List<double>(4,11.0,22.0,33.0,55.0);
  TEST_RUN("l8.remove(77.0)", l8.copy(ltemp1); l8.remove(77.0),
	   (l8==ltemp1), TRUE);
  TEST_RUN("l8.remove(44.0)", l8.remove(44.0),
	   (l8==ltemp2 && l8.value()==55.0), TRUE);

  ltemp1 = List<double>(4,11.0,22.0,33.0,44.0);
  TEST_RUN("l11.remove_duplicates()", l11.remove_duplicates(), (l11==ltemp1),
	   TRUE);

  // l8 is now (11 22 33 55)
  ltemp2 = List<double>(4,11.0,55.0,33.0,55.0);
  TEST_RUN("l8.replace(66.0,22.0)", l8.copy(ltemp1); l8.replace(66.0,22.0),
	   (l8==ltemp1), TRUE);
  TEST_RUN("l8.replace(22.0,55.0)", l8.copy(ltemp1); l8.replace(22.0,55.0),
	   (l8==ltemp2 && l8.value()==55.0), TRUE);

  ltemp2 = List<double>(4,11.0,22.0,33.0,22.0);
  TEST_RUN("l8.replace_all(66.0,22.0)",
	   l8.copy(ltemp1); l8.replace_all(66.0,22.0), 
	   (l8==ltemp1), TRUE);
  TEST_RUN("l8.replace_all(55.0,22.0)",
	   l8.copy(ltemp1); l8.replace_all(55.0,22.0), 
	   (l8==ltemp2), TRUE);

  // l8 is now (11 22 33 22)
  ltemp2 = List<double>(5,11.0,22.0,111.0,33.0,22.0);
  TEST_RUN("l8.insert_after(111.0,44.0)",
	   l8.copy(ltemp1); l8.insert_after(111.0,44.0), 
	   (l8==ltemp1), TRUE);
  TEST_RUN("l8.insert_after(111.0,22.0)",
	   l8.copy(ltemp1); l8.insert_after(111.0,22.0), 
	   (l8==ltemp2 && l8.value()==111.0), TRUE);

  TEST_RUN("l8.insert_before(222.0,44.0)",
	   l8.copy(ltemp1); l8.insert_before(222.0,44.0), 
	   (l8==ltemp1), TRUE);
  ltemp2 = List<double>(6,11.0,222.0,22.0,111.0,33.0,22.0);
  TEST_RUN("l8.insert_before(222.0,22.0)", l8.insert_before(222.0,22.0),
	   (l8==ltemp2 && l8.value()==222.0), TRUE);
  ltemp2 = List<double>(7,333.0,11.0,222.0,22.0,111.0,33.0,22.0);
  TEST_RUN("l8.insert_before(333.0,11.0)", l8.insert_before(333.0,11.0),
	   (l8==ltemp2 && l8.value()==333.0), TRUE);
}

void list_double_set_test1() {

  List<double> ltemp1;
  List<double> l1;
  List<double> l2(4,11.0,22.0,33.0,44.0);
  List<double> l3(2,22.0,33.0);
  List<double> l4(5,11.0,22.0,33.0,44.0,55.0);
  List<double> l5(12,1.0,55.0,3.0,88.0,77.0,44.0,33.0,22.0,11.0,66.0,2.0,3.0);
  List<double> l6(5,11.0,66.0,111.0,33.0,55.0);


  TEST("l2.find(33.0)", (l2.find(33.0) && l2.value()==33.0), TRUE);
  TEST("l2.find(2.0)", l2.find(2.0), FALSE);

  TEST("l2.search(l3)", (l2.search(l3) && l2.value()==22.0), TRUE);
  TEST("l2.search(l1)", l2.search(l1), FALSE);
  TEST("l2.search(l4)", l2.search(l4), FALSE);
  TEST("l4.search(l2)", (l4.search(l2) && l4.value()==11.0), TRUE);
  TEST("l1.search(l2)", l1.search(l2), FALSE);

  TEST_RUN("l2.member(ltemp1, 22.0)", l2.member(ltemp1, 22.0),
	   (ltemp1.length()==3, ltemp1[0]==22.0 && ltemp1[1]==33.0,
	    ltemp1[2]==44.0 && l2.value()==22.0),
	   TRUE);
  TEST_RUN("l2.member(ltemp1, 44.0)", l2.member(ltemp1, 44.0),
	   (ltemp1.length()==1 && ltemp1[0]==44.0 && l2.value()==44.0),
	   TRUE);
  TEST_RUN("l2.member(ltemp1, 3.0)", l2.member(ltemp1, 3.0), 
	   (ltemp1.length()==0), TRUE);

  TEST_RUN("l2.sublist(ltemp, l3)", l2.sublist(ltemp1, l3),
	   (ltemp1.length()==3 && ltemp1[0]==22.0, ltemp1[1]==33.0, 
	    ltemp1[2]==44.0 && l2.value()==22.0), 
	   TRUE);
  TEST_RUN("l2.sublist(ltemp1, l1)", l2.sublist(ltemp1, l1),
	   (ltemp1.length()==0), TRUE);
  TEST_RUN("l2.sublist(ltemp1, l4)", l2.sublist(ltemp1, l4), 
	   (ltemp1.length()==0), TRUE);
  TEST_RUN("l4.sublist(ltemp1, l2)", l4.sublist(ltemp1, l2), 
	   (ltemp1==l4 && l4.value()==11.0), TRUE);
  TEST_RUN("l1.sublist(ltemp1, l2)", l1.sublist(ltemp1, l2), 
	   (ltemp1.length()==0), TRUE);

  ltemp1 = List<double>(4,55.0,33.0,11.0,66.0);
  TEST_RUN("l5.intersection(l6)", l5.intersection(l6), (l5==ltemp1), TRUE);

  ltemp1 = List<double>(5,111.0,55.0,33.0,11.0,66.0);
  TEST_RUN("l5.lunion(l6)", l5.lunion(l6), (l5==ltemp1), TRUE);

  TEST_RUN("l5.difference(l6)", ltemp1.clear(); l5.difference(l6), 
	   (l5==ltemp1), TRUE);

  ltemp1 = List<double>(5,11.0,66.0,111.0,33.0,55.0);
  TEST_RUN("l5.exclusive_or(l6)", l5.exclusive_or(l6), (l5==ltemp1), TRUE);

}

void list_double_set_test2() {

  List<double> ltemp1;
  List<double> l7(2,2.0,3.0);
  List<double> l8(3,1.0,2.0,3.0);
  List<double> l9 = l7 + l8;
  List<double> l10(3,4.0,5.0,6.0);
  List<double> l11(12,1.0,55.0,3.0,88.0,77.0,44.0,33.0,22.0,11.0,66.0,2.0,3.0);
  List<double> l12(5,11.0,66.0,111.0,33.0,55.0);
  List<double> l13;

  ltemp1 = List<double>(5,2.0,3.0,1.0,2.0,3.0);
  TEST("l9 = l7 + l8", (l9==ltemp1), TRUE);
  ltemp1 = List<double>(5,2.0,3.0,4.0,5.0,6.0);
  TEST_RUN("l7 += l10", l7 += l10, (l7==ltemp1), TRUE);

  ltemp1 = List<double>(4,55.0,33.0,11.0,66.0);
  TEST_RUN("l11 &= l12", l11 &= l12, (l11==ltemp1), TRUE);

  ltemp1 = List<double>(5,111.0,55.0,33.0,11.0,66.0);
  TEST_RUN("l11 |= l12", l11 |= l12, (l11==ltemp1), TRUE);

  TEST_RUN("l11 -= l12", ltemp1.clear(); l11 -= l12, (l11==ltemp1), TRUE);

  ltemp1 = List<double>(5,11.0,66.0,111.0,33.0,55.0);
  TEST_RUN("l11 ^= l12", l11 ^= l12, (l11==ltemp1), TRUE);

  l11 = List<double>(12,1.0,55.0,3.0,88.0,77.0,44.0,33.0,22.0,11.0,66.0,2.0,
		     3.0);
  l12 = List<double>(5,11.0,66.0,111.0,33.0,55.0);

  ltemp1 = List<double>(4,55.0,33.0,11.0,66.0);
  TEST_RUN("l13 = l11 & l12", l13 = l11 & l12, (l13==ltemp1), TRUE);

  ltemp1 = List<double>(13,111.0,1.0,55.0,3.0,88.0,77.0,44.0,33.0,22.0,11.0,
			66.0,2.0,3.0);
  TEST_RUN("l13 = l11 | l12", l13 = l11 | l12, (l13==ltemp1), TRUE);

  ltemp1 = List<double>(8,1.0,3.0,88.0,77.0,44.0,22.0,2.0,3.0);
  TEST_RUN("l13 = l11 - l12", l13 = l11 - l12, (l13==ltemp1), TRUE);

  ltemp1 = List<double>(9,1.0,3.0,88.0,77.0,44.0,22.0,2.0,3.0,111.0);
  TEST_RUN("l13 = l11 ^ l12", l13 = l11 ^ l12, (l13==ltemp1), TRUE);

}

void list_double_sort_test() {

  List<double> l1(4,6.0,66.0,22.0,222.0);
  List<double> l2(4,61.0,12.0,222.0,666.0);
  List<double> l3(4,7.0,51.0,77.0,24.0);
  List<double> ltemp1;

  ltemp1 = List<double>(8,6.0,61.0,12.0,66.0,22.0,222.0,222.0,666.0);
  TEST_RUN("l1.merge(l2,my_compare_double)", l1.merge(l2,my_compare_double), 
	   (l1==ltemp1), TRUE);

  ltemp1 = List<double>(4,12.0,61.0,222.0,666.0);
  TEST_RUN("l2.sort(my_compare_double)", l2.sort(my_compare_double), 
	   (l2==ltemp1), TRUE);

  ltemp1 = List<double>(4,7.0,24.0,51.0,77.0);
  TEST_RUN("l3.sort(my_compare_double)", l3.sort(my_compare_double),
	   (l3==ltemp1), TRUE);

}

void list_double_currentpos_test() {

  List<double> l1(3,11.0,22.0,33.0);
  List<double> l2;
  List<double> ltemp1;

  TEST_RUN("l1.next()",l1.next(),l1.value(), 11.0);
  
  ltemp1 = List<double>(4,11.0,55.0,22.0,33.0);
  TEST_RUN("l1.insert_after(55.0)", l1.insert_after(55.0), 
	   (l1.value()==55.0 && l1==ltemp1), TRUE);

  TEST_RUN("l1.prev()",l1.prev(),l1.value(), 11.0);

  ltemp1 = List<double>(5,66.0,11.0,55.0,22.0,33.0);
  TEST_RUN("l1.insert_before(66.0)", l1.insert_before(66.0), 
	   (l1.value()==66.0 && l1==ltemp1), TRUE);

  ltemp1 = List<double>(4,11.0,55.0,22.0,33.0);
  TEST("l1.remove()", (l1.remove()==66.0 && l1.value()==11.0 && l1==ltemp1),
        TRUE);

  ltemp1 = List<double>(3,11.0,55.0,33.0);
  TEST_RUN("l1.remove()", l1.next();l1.next(),
	   (l1.remove()==22.0 && l1.value()==33.0 && l1==ltemp1),
	   TRUE);

  TEST_RUN("l1.position()", l1.prev(), (l1.position()==1 && l1.value()==55.0),
	   TRUE);

  // l1 is (11.0,55.0,33.0)
  l2 = List<double>(4,55.0,66.0,33.0,22.0);

  TEST_RUN("l1.next_lunion(l2)", l1.reset(),
	   (l1.next_lunion(l2) && l1.value()==11.0), TRUE);
  TEST_RUN("l1.next_lunion(l2)", l1.next_lunion(l2); l1.next_lunion(l2),
	   (l1.next_lunion(l2) && l1.value()==66.0),TRUE);
  TEST("l1.next_lunion(l2)", (l1.next_lunion(l2) && l1.value()==22.0),TRUE);
  TEST("l1.next_lunion(l2)", l1.next_lunion(l2), FALSE);

  TEST_RUN("l1.next_intersection(l2)", l1.reset(),
	   (l1.next_intersection(l2) && l1.value()==55.0),
	   TRUE);
  TEST("l1.next_intersection(l2)", 
       (l1.next_intersection(l2) && l1.value()==33.0),
       TRUE);
  TEST("l1.next_intersection(l2)", l1.next_intersection(l2), FALSE);
  TEST_RUN("l1.next_difference(l2)", l1.reset(),
	   (l1.next_difference(l2) && l1.value()==11.0), 
	   TRUE);
  TEST("l1.next_difference(l2)", l1.next_difference(l2), FALSE);
  TEST_RUN("l1.next_exclusive_or(l2)", l1.reset(),
	   (l1.next_exclusive_or(l2) && l1.value()==11.0),
	   TRUE);
  TEST_RUN("l1.next_exclusive_or(l2)", l1.next_exclusive_or(l2),
	   (l1.next_exclusive_or(l2) && l1.value()==22.0),
	   TRUE);
  TEST("l1.next_exclusive_or(l2)", l1.next_exclusive_or(l2), FALSE);
}

void list_double_io_test() {

  // ** an automated test would get input from file, rather than cin **
  List<double> input_list;
//  cout << "\nTesting operator>> for List<double>.";
//  cout << "\nExample of List<double> is (1 2 3).";
//  cout << "\nPlease enter a List<double> structure: ";
//  cin >> input_list;
//  cout << "\nInput_list is now set to: " << input_list << ".\n";

}

void test_list_double() {
  cout << "\n*** Testing List of Double ***\n\n";
  list_double_op_test1();
  list_double_op_test2();
  list_double_op_test3();
  list_double_op_test4();
  list_double_set_test1();
  list_double_set_test2();
  list_double_sort_test();
  list_double_currentpos_test();
  list_double_io_test();

}

// *******************
// List of char* tests
// *******************

void list_charp_op_test() {

  char* a = "a";
  char* b = "b";
  char* c = "c";
  char* d = "d";
  char* e = "e";

  List<char*> l0;
  TEST("List<char*> l0", 1, 1);

  List<char*> l1(c);
  TEST("List<char*> l1(c)", 1, 1);

  List<char*> l2(b,l1);
  TEST("List<char*> l2(b,l1)", 1, 1);

  List<char*> l3(a,l2);
  TEST("List<char*> l3(a,l2)", 1, 1);

  List<char*> l4(3,a,b,c);
  TEST("List<char*> l4(3,a,b,c)", 1, 1);

  List<char*> l5(l4);
  TEST("List<char*> l5(l4)", 1, 1);

  TEST("l3==l4", l3==l4, TRUE);
  TEST_RUN("l4[2]=d", l4[2]=d, l4[2]==d, TRUE);

}

// *******************
// List of char tests
// *******************

void list_char_op_test() {

  char a = 'a';
  char b = 'b';
  char c = 'c';
  char d = 'd';
  char e = 'e';

  List<char> l0;
  TEST("List<char> l0", 1, 1);

  List<char> l1(c);
  TEST("List<char> l1(c)", 1, 1);

  List<char> l2(b,l1);
  TEST("List<char> l2(b,l1)", 1, 1);

  List<char> l3(a,l2);
  TEST("List<char> l3(a,l2)", 1, 1);

  List<char> l4(3,a,b,c);
  TEST("List<char> l4(3,a,b,c)", 1, 1);

  List<char> l5(l4);
  TEST("List<char> l5(l4)", 1, 1);

//  TEST("l3==l4", l3==l4, TRUE);
//  cout << l3 << l4 << "\n";

  TEST_RUN("l4[2]=d", l4[2]=d, l4[2]==d, TRUE);

}

void test_list_chars() {
  cout << "\n*** Testing List of Char* ***\n\n";
  list_charp_op_test();
  cout << "\n*** Testing List of Char ***\n\n";
  list_char_op_test();

}

void test_list_vector() {

  cout << "\n*** Testing List of Vector of Int ***\n\n";
  Vector<int> v1(3,3,1,2,3);
  Vector<int> v2(3,3,1,2,3);

  List<Vector<int>> l0;
  TEST("List<Vector<int>> l0", 1, 1);

  List<Vector<int>> l1(v1);
  TEST("List<Vector<int>> l1(v1)", (l1[0]==v1), 1);

  List<Vector<int>*> l2(2,&v1,&v2);
  TEST("List<Vector<int>*> l2(2,&v1,&v2);", (l2[0]==&v1 && l2[1]==&v2), 1);

//  List<Vector<int>> l3(2,v1,v2);
//  TEST("List<Vector<int>> l3(2,v1,v2);", (l3[0]==v1 && l3[1]==v2), 1);

}

void test_list_list() {

  cout << "\n*** Testing List of List ***\n\n";
  List<int> l1(3,1,2,3);

  List<List<int>> l2(l1);
  TEST("List<List<int>> l2(l1)", (l2[0]==l1), 1);

  List<List<int>*> l4(&l1);
  TEST("List<List<int>*> l4(&l1)", (l4[0]==&l1), 1);

  List<int>* l5 = &l1;
  List<List<int>*> l6(l5);
  TEST("List<List<int>*> l6(l5)", (l6[0]==&l1), 1);

//  List<List<int>> l3(2,l1,l1);
//  TEST("List<List<int>> l2(2,l1,l1)", (l2[0]==l1 && l2[1]==l1), 1);

}


void test_list_generic() {

  cout << "\n*** Testing List of Generic*  ***\n\n";
  List<int> l1(3,1,2,3);
  Vector<int> v1(3,3,1,2,3);

  List<Generic*> l2;
  TEST("List<Generic*> l2;", 1, 1);

  List<Generic*> l3(2,&l1,&v1);
  TEST("List<Generic*> l3(2,&l1,&v1);", 1, 1);

}


