//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MBN 09/18/89 -- Changed ERR_MSG package name to uppercase.
// Updated: LGO 09/20/89 -- Split into separate file.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// *******************************************************
// Member function for System_Signal class
// *******************************************************

// void System_Signal::report(ostream&) -- reports the System_Signal message
//                                         on specified output stream.
// Input:   Output stream.
// Output:  None.

void System_Signal::report(ostream& os) CONST {
  os << this->message_prefix() << ": ";
  if (this->signo < 0)
    os << form(ERR_MSG("Unknown System Signal (%d) was raised."), this->signo)
       << "\n";
  else
    os << form(ERR_MSG("Signum %d was raised."), this->signo) << "\n";
}
