//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MBN 09/18/89 -- Changed ERR_MSG package name to uppercase.
// Updated: LGO 09/20/89 -- Split into separate file.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// ******************************************************
// report member function for System_Error class
// ******************************************************

// strerror(int) - returns a pointer to the error string of errnun.
//                 This function definition is ANSI but currently unavailable.
//
#if defined(DOS)                        // Microsoft already has this
extern "C" {
#include <string.h>			// for strerror() support 
}
#else
char* strerror(int errnum) {
  // SYS_ERRLIST is a vector of system error message string pointers.
  // which can be indexed by the value in ERRNO.
  // SYS_NERR is the number of messages provided for in the table.
  // SYS_NERR needs to be checked because new error codes may be added
  // to the system before they are added to the SYS_ERRLIST table

  if (errnum >=0 && errnum < sys_nerr)
    return sys_errlist[errnum]; 
  else return NULL;
}
#endif

// System_Error::report(ostream&) -- reports the System_Error message on
//                                   the specified output stream.
// INPUT:  Output stream.
// OUTPUT: None.

void System_Error::report(ostream& os) CONST {
  os << this->message_prefix() << ": ";
  char* sys_msg =  strerror(this->error_code); // strerror() is ANSI
  if (sys_msg == NULL || this->error_code == -1)
    os << form(ERR_MSG("Unknown System Error (%d) was signalled."),
	       this->error_code) << "\n";
  else
    os << sys_msg << ".\n";
}
