//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// Boolean message_prefix() - returns the message prefix of this Exception
//
// INPUT:   None.
// OUTPUT:  None.

const char* Exception::message_prefix() CONST {
  if (this->msg_prefix == NULL)
#if GENERIC_TYPECHECK				// If symbols available
    return (this->type_of())->name();
#else
    return "Exception";
#endif
  else return this->msg_prefix;

}
