/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1988. */

/* This is slightly edited from a public domain version */

#include "b.h"

#ifndef HAS_MKDIR

/* mkdir - Make a directory */

Visible int mkdir(dir, mode) char *dir; int mode; {
	char buf[1024];

	sprintf(buf, "(mkdir %s && chmod %o %s) >/dev/null 2>/dev/null",
			dir, mode, dir);
	return(system(buf));
}

/* rmdir - remove directory */

Visible Procedure rmdir(dir) char *dir; {
	char buf[1024];

	sprintf(buf, "rmdir %s >/dev/null 2>/dev/null", dir);
	return(system(buf));
}

#endif /* !HAS_MKDIR */

#ifndef HAS_READDIR

#include "dir.h"

/*
 * support for Berkeley directory reading routines
 * on a VERSION7 or ATT file system
 */

/* open a directory */

Visible DIR *opendir(name) char *name; {
	register DIR *dirp;
	register int fd;
	char *malloc();

	if ((fd = open(name, 0)) == -1)
		return NULL;
	if ((dirp = (DIR *)malloc(sizeof(DIR))) == NULL) {
		close (fd);
		return NULL;
	}
	dirp->dd_fd = fd;
	dirp->dd_loc = 0;
	return dirp;
}

/* read an old style directory entry and present it as a new one */
#ifndef pyr
#define	ODIRSIZ	14

struct	olddirect {
	ino_t	od_ino;
	char	od_name[ODIRSIZ];
};
#else	/* a Pyramid in the ATT universe */
#define	ODIRSIZ	248

struct	olddirect {
	long	od_ino;
	short	od_fill1, od_fill2;
	char	od_name[ODIRSIZ];
};
#endif

/* get next entry in a directory */

Visible struct direct *readdir(dirp) register DIR *dirp; {
	register struct olddirect *dp;
	static struct direct dir;

	for (;;) {
		if (dirp->dd_loc == 0) {
			dirp->dd_size = read(dirp->dd_fd, dirp->dd_buf,
			    DIRBLKSIZ);
			if (dirp->dd_size <= 0)
				return NULL;
		}
		if (dirp->dd_loc >= dirp->dd_size) {
			dirp->dd_loc = 0;
			continue;
		}
		dp = (struct olddirect *)(dirp->dd_buf + dirp->dd_loc);
		dirp->dd_loc += sizeof(struct olddirect);
		if (dp->od_ino == 0)
			continue;
		dir.d_ino = dp->od_ino;
		strncpy(dir.d_name, dp->od_name, ODIRSIZ);
		dir.d_name[ODIRSIZ] = '\0'; /* insure null termination */
		dir.d_namlen = strlen(dir.d_name);
		dir.d_reclen = DIRSIZ(&dir);
		return (&dir);
	}
}

/* close a directory */

Visible Procedure closedir(dirp) register DIR *dirp; {
	close(dirp->dd_fd);
	dirp->dd_fd = -1;
	dirp->dd_loc = 0;
	free(dirp);
}

#endif /* !HAS_READDIR */
