/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1986. */

/* Access and update lists and tables */

#include "b.h"
#include "bint.h"
#include "bobj.h"
#include "i1tlt.h"

#define INSERT_LIS	MESS(100, "inserting in non-list")
#define INSERT_RAN	MESS(101, "cannot insert in large range")

#define REMOVE_LIS	MESS(102, "removing from non-list")
#define REMOVE_EMPTY	MESS(103, "removing from empty list")
#define REMOVE_ENTRY	MESS(104, "removing non-existent list entry")
#define REMOVE_RAN	MESS(105, "cannot remove from large range")

#define RANGE_BIG	MESS(107, "exceedingly large range in display")

#define REPLACE_TAB	MESS(115, "replacing in non-table")

#define KEYS_TAB	MESS(116, "in keys t, t is not a table")

#define SEL_TAB		MESS(117, "in t[k], t is not a table")
#define SEL_EMPTY	MESS(118, "in t[k], t is empty")
#define SEL_KEY		MESS(119, "in t[k], k is not a key of t")

/* B lists */

/* Rangedisplays will be set up as rangelists, only holding lwb and upb
 * iff they contain more than Minrange elements.
 * Minrange might even be just 1.
 */
#define Minrange	(2)

Forward value spawn_range();

Visible bool is_rangelist(v) value v; {
	return (bool) Is_range(v);
}

Visible value list_elem(l, i) value l; intlet i; {
	return List_elem(l, i);
}

extern bool found_ok;

Visible insert(v, ll) value v, *ll; {
	intlet len; register value *lp, *lq;
	intlet k; register intlet kk;
	if (!Is_list(*ll)) {
		interr(INSERT_LIS);
		return;
	}
	if (Is_range(*ll)) {
		value l = spawn_range(Lwb(*ll), Upb(*ll));
		if (l == Vnil) {
			interr(INSERT_RAN);
			return;
		}
		release((value)(*ll));
		*ll = l;
	}
	len= Length(*ll);
	VOID found(list_elem, *ll, v, &k);
	if (!found_ok) return;
	if (Unique(*ll) && !Is_ELT(*ll)) {
		xtndlt(ll, 1);
		lq= Ats(*ll)+len; lp= lq-1;
		for (kk= len; kk > k; kk--) *lq--= *lp--;
		*lq= copy(v);
	} else {
		value w;
		lp= Ats(*ll);
		release(*ll);
		*ll= grab(Lis, ++len);
		lq= Ats(*ll);
		for (kk= 0; kk < len; kk++) {
			w= kk == k ? v : *lp++;
			*lq++= copy (w);
		}
	}
}

Visible remove(v, ll) value v; value *ll; {
	register value *lp, *lq;
	intlet k, len;
	if (!Is_list(*ll)) {
		interr(REMOVE_LIS);
		return;
	}
	if (Length(*ll) == 0) {
		interr(REMOVE_EMPTY);
		return;
	}
	if (Is_range(*ll)) {
		value l = spawn_range(Lwb(*ll), Upb(*ll));
		if (l == Vnil) {
			interr(REMOVE_RAN);
			return;
		}
		release((value)(*ll));
		*ll = l;
	}
	if (!found(list_elem, *ll, v, &k))
		interr(REMOVE_ENTRY);
	else {
		len= Length(*ll);
		lp= Ats(*ll); /* lp[k] = v */
		if (Unique(*ll)) {
			release(*(lp+=k));
			for (k= k; k < len; k++) {*lp= *(lp+1); lp++;}
			xtndlt(ll, -1);
		} else {
			intlet kk= k;
			lq= Ats(*ll);
			release(*ll);
			*ll= grab(Lis, --len);
			lp= Ats(*ll);
			for (k= 0; k < len; k++) {
				if (k == kk) lq++;
				*lp++= copy (*lq); lq++;
			}
		}
	}
}

Visible value rangesize(lwb, upb) value lwb, upb; {
	value d, r;
	d = diff(upb, lwb);
	r = sum(d, one);
	release(d);
	return r;
}

Hidden value spawn_range(lo, hi) value lo, hi; {
	value s;
	value l, *lp;
	value v, w;
	int i;
	intlet k, len;
	bool enough_space();
	
	if (large(s = rangesize(lo, hi))
	    ||
	    (i = intval(s)) > Maxintlet
	    ||
	    !enough_space(Lis, len = (intlet) i)
	) {
		release(s);
		return Vnil;
	}
	release(s);
	l = grab(Lis, len);
	lp = Ats(l);
	v = copy(lo);
	for (k= 0; k < len; k++) {
		*lp++ = copy(v);
		v = sum(w = v, one);
		release(w);
	}
	release(v);
	return l;
}

Hidden value mk_numrange(lo, hi) value lo, hi; {
	value l, r;
	
	if (large(r= rangesize(lo, hi)) || intval(r) >= Minrange) {
		l= grab(Ran, 2);
		Lwb(l)= copy(lo);
		Upb(l)= copy(hi);
	}
	else {
		l= spawn_range(lo, hi);
		if (l == Vnil)
			interr(RANGE_BIG);
	}
	release(r);
	return l;
}

Hidden value i_range(lo, hi) value lo, hi; {
	value r, res= Vnil;

	if (compare(r= rangesize(lo, hi), one) < 0)
		res= mk_elt();
	else 
		res= mk_numrange(lo, hi);
	release(r);

	return res;
}

Hidden value mk_charrange(a, z) char a, z; {
	value l= grab(Lis, (intlet) (z-a+1)); register value *ep= Ats(l);
	char m[2];
	m[1]= '\0';
	for (m[0]= a; m[0] <= z; m[0]++) {
		*ep++= mk_text(m);
	}
	return l;
}

Hidden value c_range(lo, hi) value lo, hi; {
	char a, z;

	a= charval(lo); z= charval(hi);
	if (z <= a-1) return mk_elt();
	else return mk_charrange(a, z);
}

Visible value mk_range(v1, v2) value v1, v2; {
	if (Is_text(v1)) return c_range(v1, v2);
	else return i_range(v1, v2);
}

Visible relation range_comp(v, w) value v, w; {
	/* Type(v) == Ran || Type(w) == Ran, and other type Is_list */
	relation ci, cs;
	value s, vs, ws, i, vi, wi, k;
	
	if (Is_range(v) && Is_range(w)) {
		ci = compare(Lwb(v), Lwb(w));
		if (ci == 0)
			ci = compare(Upb(v), Upb(w));
	}
	else {
		i = copy(one);
		vs = size(v); ws = size(w);
		if ((cs = compare(vs, ws)) <= 0)
			s = copy(vs);
		else
			s = copy(ws);
		release(vs); release(ws);
		ci = 0;		/* for ELT */
		while (numcomp(i, s) <= 0) {
			vi = item(v, i); wi = item(w, i);
			ci = compare(vi, wi);
			release(vi); release(wi);
			if (ci != 0)
				break;
			i = sum(k=i, one);
			release(k);
		}
		release(i); release(s);
		if (ci == 0)
			ci = cs;
	}
	return ci;
}
/**********************************************************************/

/* B tables */

Visible value* key(v, k) value v; intlet k; { /* k in {0..size-1}; no copy */
	return Key(v, k);
}

Visible value* assoc(v, k) value v; intlet k; { /* k in {0..size-1}; no copy */
	return Assoc(v, k);
}

Visible value associate(v, k) value v; value k; {
	value *p= adrassoc(v, k);
	if (p != Pnil) return copy(*p);
	interr(SEL_KEY);
	return Vnil;
}

Visible value keys(ta) value ta; {
	
	if(!Is_table(ta)) {
		interr(KEYS_TAB);
		return grab(Lis, 0);
	} else {
		value li= grab(Lis, Length(ta)), *le, *te= (value *)Ats(ta);
		int k, len= Length(ta);
		le= (value *)Ats(li);
		for (k= 0; k < len; k++) { *le++= copy(Cts(*te)); te++; }
		return li;
	}
}

Visible value key_elem(t, i) value t; intlet i; { /*The key of the i-th entry*/
	return *Key(t, i);
}

/* adrassoc returns a pointer to the associate, rather than
   the associate itself, so that the caller can decide if a copy
   should be taken or not. If the key is not found, Pnil is returned. */
Visible value* adrassoc(t, ke) value t, ke; {
	intlet where;
	if (Type(t) != Tab && Type(t) != ELT) {
		interr(SEL_TAB);
		return Pnil;
	}
	return found(key_elem, t, ke, &where) ? Assoc(t, where) : Pnil;
}

Visible Procedure uniq_assoc(ta, ke) value ta, ke; {
	intlet k;
	if (found(key_elem, ta, ke, &k)) {
		uniql(Ats(ta)+k);
		uniql(Assoc(ta,k));
	} else syserr(MESS(120, "uniq_assoc called for non-existent table entry"));
}

Visible Procedure replace(v, ta, ke) value *ta, ke, v; {
	intlet len; value *tp, *tq;
	intlet k, kk;
	uniql(ta);
	if (Type(*ta) == ELT) (*ta)->type = Tab;
	else if (Type(*ta) != Tab) {
		interr(REPLACE_TAB);
		return;
	}
	len= Length(*ta);
	if (found(key_elem, *ta, ke, &k)) {
		value *a;
		uniql(Ats(*ta)+k);
		a= Assoc(*ta, k);
		/* uniql(a); */
		release(*a);
		*a= copy(v);
		return;
	} else if (found_ok) {
		xtndlt(ta, 1);
		tq= Ats(*ta)+len; tp= tq-1;
		for (kk= len; kk > k; kk--) *tq--= *tp--;
		*tq= grab(Com, 2);
		Cts(*tq)= copy(ke);
		Dts(*tq)= copy(v);
	}
}

Visible bool in_keys(ke, tl) value ke, tl; {
	intlet dummy;
	if (Type(tl) == ELT) return No;
	if (Type(tl) != Tab) syserr(KEYS_TAB);
	return found(key_elem, tl, ke, &dummy);
}

Visible Procedure delete(tl, ke) value *tl, ke; {
	intlet len, k; value *tp;
	if (Type(*tl) == ELT) 
		syserr(MESS(121, "deleting table entry from empty table"));
	if (Type(*tl) != Tab)
		syserr(MESS(122, "deleting table entry from non-table"));
	tp= Ats(*tl); len= Length(*tl);
	if (!found(key_elem, *tl, ke, &k))
		syserr(MESS(123, "deleting non-existent table entry"));
	if (Unique(*tl)) {
		release(*(tp+=k));
		for (k= k; k < len; k++) {*tp= *(tp+1); tp++;}
		xtndlt(tl, -1);
	} else {
		intlet kk; value *tq= Ats(*tl);
		release(*tl);
		*tl= grab(Tab, --len);
		tp= Ats(*tl);
		for (kk= 0; kk < len; kk++) {
			*tp++= copy (*tq); tq++;
			if (kk == k) tq++;
		}
	}
}

#define Len(len) (len < 200 ? len : ((len-1)/8+1)*8)

Hidden Procedure
xtndlt(a, d)
	value *a; intlet d;
{
	intlet len= Length(*a); intlet l1= Len(len), l2;
	len+= d; l2= Len(len);
	if (l1 != l2) {
		regrab(a, l2);
	}
	(*a)->len= len;
}

