/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1987. */

#define p_exists(pname, aa)	(in_env(b_perm, pname, aa))
#define def_perm(pname, f)	(e_replace(f, &b_perm, pname), permchanges= Yes)
#define free_perm(pname)	(e_delete(&b_perm, pname), permchanges= Yes)

#define u_exists(pname, aa)	(in_env(b_units, pname, aa))
#define def_unit(pname, u)	(e_replace(u, &b_units, pname))
#define free_unit(pname)	(e_delete(&b_units, pname))

extern value b_perm;
extern bool permchanges;
extern value b_units;
extern value last_unit;
extern value last_target;

#define Permname(pname) (behead(pname, MkSmallInt(2)))
#define Permtype(pname) (strval(pname)[0])
	/* possible types:
	 *	1-8 [Cmd ... Tar]	(order used in mac/m1print.c!)
	 *	: [last_unit]
	 *	= [last_target]
	 */

#define Cmd '1'
#define Zfd '2'
#define Mfd '3'
#define Dfd '4'
#define Zpd '5'
#define Mpd '6'
#define Dpd '7'
#define Tar '8'
#define OldHow '+'	/* old how-to type (used in bio) */
#define OldTar '-'	/* old target type (used in bio) */
#define Wsp '.'		/* workspace type */

#define	Cmd_ext ".cmd"
#define Zfd_ext ".zfd"
#define Mfd_ext ".mfd"
#define Dfd_ext ".dfd"
#define Zpd_ext ".zpd"
#define Mpd_ext ".mpd"
#define Dpd_ext ".dpd"
#define Cts_ext ".cts"
#define Wsp_ext ""

value permkey();
value get_pname();
value getval();

value new_fname();		/* devise a filename for a unit or target */
value mkabcname();		/* vice versa for recovering target name */
#define CONVP_SIGN '_'		/* to map point */
#define CONVDQ_SIGN '@'		/* to map double quote */

bool is_udfpr();		/* REPORT is user defined func or predic */
