/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1988. */

#include "b.h"
#include "bint.h"
#include "bfil.h"
#include "bmem.h"
#include "bobj.h"
#include "args.h"
#include "feat.h"
#include "i2par.h"
#include "i3bws.h"
#include "i3env.h"
#include "i3sou.h"

/* ******************************************************************** */
/*		workspace routines					*/
/* ******************************************************************** */

Visible char *bwsdir= (char *) NULL;	/* group name workspaces */

Visible value ws_group= Vnil;		/* index workspaces */
Visible bool groupchanges= No;		/* if Yes index is changed */

Visible value curwskey= Vnil;		/* special index key for cur_ws */
Visible value lastwskey= Vnil;		/* special index key for last_ws */

Visible value cur_ws= Vnil;		/* the current workspace */
					/* only visible for m1bio.c */
Hidden value last_ws= Vnil;		/* the last visited workspace */

Hidden bool path_workspace= No;		/* if Yes no workspace change allowed */

#define gr_exists(name, aa) (in_env(ws_group, name, aa))
#define def_group(name, f)  (e_replace(f, &ws_group, name), groupchanges= Yes)
#define free_group(name)    (e_delete(&ws_group, name), groupchanges= Yes)

#ifndef DIRMODE
#define DIRMODE 0777
#endif

/* ******************************************************************** */

#define DEFAULT_WS	"first"

#define CURWSKEY	">"
#define LASTWSKEY	">>"

Hidden Procedure initgroup() {
	wsgroupfile= (string) makepath(bwsdir, WSGROUPFILE);
	curwskey= mk_text(CURWSKEY);
	lastwskey= mk_text(LASTWSKEY);
	if (F_exists(wsgroupfile)) {
		value fname= mk_text(wsgroupfile);
		ws_group= getval(fname, In_wsgroup);
		release(fname);
		if (!still_ok) {
			still_ok= Yes;
			rec_wsgroup();
		}
		
	}
	else ws_group= mk_elt();
	groupchanges= No;
}

Hidden Procedure endgroup() {
	save_curlast(curwskey, cur_ws);
	save_curlast(lastwskey, last_ws);
	only_default();
	put_wsgroup();
}

Hidden Procedure save_curlast(wskey, ws) value wskey, ws; {
	value *aa;
	
	if (Valid(ws) && (!gr_exists(wskey, &aa) || (compare(ws, *aa) != 0)))
		def_group(wskey, ws);
}

/*
 * removes the default entry if it is the only one;
 * the default is [CURWSKEY]: DEFAULT_WS;
 * this has to be done to create the possibility of removing an empty
 * wsgroupfile and bwsdefault directory;
 * still this will hardly happen (see comments in endbws() )
 */

Hidden Procedure only_default() {
	value *aa;

	if (length(ws_group) == 1 &&
		Valid(curwskey) && gr_exists(curwskey, &aa) 
	   ) {
	   	value defws= mk_text(DEFAULT_WS);
	   	if (compare(defws, *aa) == 0)
	   		free_group(curwskey);
	   	release(defws);
	}
}

Hidden Procedure put_wsgroup() {
	value fn;
	intlet len;
	
	if (!groupchanges || !Valid(ws_group))
		return;
	fn= mk_text(wsgroupfile);
	/* Remove the file if empty */
	len= length(ws_group);
	if (len == 0)
		f_delete(fn);
	else
		putval(fn, ws_group, Yes, In_wsgroup);
	release(fn);
	groupchanges= No;
}

/* ******************************************************************** */

Hidden bool wschange(ws) value ws; {
	value name, *aa;
	bool new= No, changed;
	char *path;

	if (gr_exists(ws, &aa))
		name= copy(*aa);
	else {
		name= new_fname(ws, Wsp);
		if (!Valid(name))
			return No;
		new= Yes;
	}
	path= makepath(bwsdir, strval(name));
	VOID Mkdir(path);
	changed= chdir(path) == 0 ? Yes : No;
	if (changed && new)
		def_group(ws, name);
	freepath(path);
	release(name);
	return changed;
}

Hidden Procedure wsempty(ws) value ws; {
	char *path, *permpath;
	value *aa;
	
	if (!gr_exists(ws, &aa))
		return;
	path= makepath(bwsdir, strval(*aa));
	permpath= makepath(path, permfile);
	if (F_exists(permpath));
	else if (strcmp(startdir, path) == 0);
	else if (rmdir(path) != 0);
	else free_group(ws);
	freepath(path);
	freepath(permpath);
}

/* ******************************************************************** */

Visible Procedure goto_ws() {
	value ws= Vnil;
	bool prname; /* print workspace name */

	if (path_workspace) {
		parerr(MESS(2900, "change of workspace not allowed"));
		return;
	}
	if (Ceol(tx)) {
		if (Valid(last_ws))
			ws= copy(last_ws);
		else
			parerr(MESS(2901, "no previous workspace"));
		prname= Yes;
	}
	else if (is_tag(&ws))
		prname= No;
	else
		parerr(MESS(2902, "I find no workspace name here"));
	
	if (still_ok && (compare(ws, cur_ws) != 0)) {
		can_interrupt= No;
		endworkspace();
		
		if (wschange(ws)) {
			release(last_ws); last_ws= copy(cur_ws);
			release(cur_ws); cur_ws= copy(ws);
		}
		else {
			parerrV(MESS(2903, "I can't goto/create workspace %s"), ws);
			still_ok= Yes;
			prname= No;
		}
		
		init_workspace(prname);
		wsempty(last_ws);
		can_interrupt= Yes;
	}
	release(ws);
}

Visible Procedure lst_wss() {
	value wslist, ws;
	value k, len, m;
	
	if (path_workspace) {
		print_wsname();
		return;
	}
	wslist= keys(ws_group);
	
	if (!in(cur_ws, wslist))
		insert(cur_ws, &wslist);
	
	k= one; len= size(wslist);
	while (numcomp(k, len) <= 0) {
		ws= item(wslist, k);
		if (compare(ws, curwskey) == 0);
		else if (compare(ws, lastwskey) == 0);
		else if (compare(ws, cur_ws) == 0)
			putSstr(stdout, ">%s ", strval(ws));
		else
			putSstr(stdout, "%s ", strval(ws));
		release(ws);
		k= sum(m= k, one);
		release(m);
	}
	if (numcomp(len, zero) > 0)
		putnewline(stdout);
	fflush(stdout);
	release(k); release(len);
	release(wslist);
}

/************************************************************************/

#define NO_PARENT	MESS(2905, "*** I cannot find parent directory\n")
#define NO_WORKSPACE	MESS(2906, "*** I cannot find workspace\n")
#define NO_DEFAULT	MESS(2907, "*** I cannot find your home directory\n")
#define USE_CURRENT	MESS(2908, "*** I shall use the current directory as your single workspace\n")
#define NO_ABCNAME	MESS(2909, "*** %s isn't an ABC name\n")
#define TRY_DEFAULT	MESS(2910, "*** I shall try the default workspace\n")

Hidden Procedure wserr(m, use_cur) int m; bool use_cur; {
	putmess(errfile, m);
	if (use_cur)
		wscurrent();
}

Hidden Procedure wserrV(m, v, use_cur) int m; value v; bool use_cur; {
	putSmess(errfile, m, strval(v));
	if (use_cur)
		wscurrent();
}

Hidden Procedure wscurrent() {
	putmess(errfile, USE_CURRENT);
	path_workspace= Yes;
}

/* ******************************************************************** */

Hidden bool wsinit() {
	value *aa;
	
	initgroup();
	cur_ws= Vnil;
	last_ws= Vnil;
	if (wsp_arg) {
		/* wsp_arg is a single name here, not a pathname */
#ifdef WSP_DIRNAME
		/* on the mac wsp_arg is a mac foldername, not an ABC wsname */
		cur_ws= abc_wsname(wsp_arg);
		if (!Valid(cur_ws))
			return No;
#else
		/* wsp_arg is here an ABC workspace name, not a path */
		cur_ws= mk_text(wsp_arg);
#endif
		if (!is_abcname(cur_ws)) {
			wserrV(NO_ABCNAME, cur_ws, No);
			wserr(TRY_DEFAULT, No);
			release(cur_ws); cur_ws= Vnil;
		}
	}
	if (gr_exists(curwskey, &aa)) {
		if (!Valid(cur_ws))
			cur_ws= copy(*aa);
		else if (compare(cur_ws, *aa) != 0)
			last_ws= copy(*aa);
		if (!Valid(last_ws) && gr_exists(lastwskey, &aa))
			last_ws= copy(*aa);
	}
	if (!Valid(cur_ws))
		cur_ws= mk_text(DEFAULT_WS);
	if (!is_abcname(cur_ws))
		wserrV(NO_ABCNAME, cur_ws, Yes);
	else if (wschange(cur_ws)) {
		path_workspace= No;
		return Yes;
	}
	else wserr(NO_WORKSPACE, Yes);
	return No;
}

Visible Procedure initbws() {
	if (is_gr_reccall) { /* recover index of group workspaces */
		if (!setbwsdir() || !D_exists(bwsdir)) {
			wserr(NO_PARENT, No);
			immexit(1);
		}
		initgroup();
		return;
	}
	if (is_path(wsp_arg)) {
		/* !bws_arg already assured in main.c */
		if (chdir(wsp_arg) != 0)
			wserr(NO_WORKSPACE, Yes);
		else 
			path_workspace= Yes;
	}
	else if (setbwsdir()) {
		if (!D_exists(bwsdir))
			wserr(NO_PARENT, Yes);
		else if (!wsinit())
			wsrelease();
	}
	else wserr(NO_DEFAULT, Yes);
	if (path_workspace) {
		release(cur_ws);
		cur_ws= mk_text(curdir());
	}
	init_workspace(Yes);
}

Visible Procedure endbws() {
	if (!is_gr_reccall) {
		endworkspace();
		VOID chdir(startdir);
		if (path_workspace) {
			release(cur_ws);
			cur_ws= Vnil;
			return;
		}
		else wsempty(cur_ws);
	}
	/* else: only index of group workspaces recovered */

	endgroup();
	/* 
	 * if the bwsdefault directory is used and empty, remove it;
	 * because of the savings of the last two visited workspaces
	 * in the file `bwsdefault`/`wsgroupfile` this will hardly happen;
	 * only if you stays for ever in the default workspace.
	 */
	if (!bws_arg && bwsdefault)
		VOID rmdir(bwsdefault); /* fails if not empty */
	wsrelease();
}

Visible bool is_path(path) char *path; {
	if (path == (char *) NULL)
		return No;
	if (strcmp(path, CURDIR) == 0 || strcmp(path, PARENTDIR) == 0)
		return Yes;
	for (; *path; path++) {
		if (Isanysep(*path)) return Yes;
	}
	return No;
}

Hidden bool setbwsdir() {
	if (bws_arg || bwsdefault) {
		if (!bws_arg) {
			bwsdir= savepath(bwsdefault); /* full path name */
			VOID Mkdir(bwsdir);
		}
		else if (!Isabspath(bws_arg))
			bwsdir= makepath(startdir, bws_arg);
		else
			bwsdir= savepath(bws_arg);
		return Yes;
	}
	return No;
}

Hidden Procedure wsrelease() {
	release(last_ws); last_ws= Vnil;
	release(cur_ws); cur_ws= Vnil;
	release(lastwskey); lastwskey= Vnil;
	release(curwskey); curwskey= Vnil;
	release(ws_group); ws_group= Vnil;
	freepath(wsgroupfile); wsgroupfile= (string) NULL;
	freepath(bwsdir); bwsdir= (char *) NULL;
}

/************************************************************************/

Hidden Procedure init_workspace(prname) bool prname; {
	if (interactive && prname)
		print_wsname();
	initworkspace();
	if (!still_ok) {
		still_ok= Yes;
		rec_workspace();
	}
}

Visible Procedure initworkspace() {
	initsou();
	initfpr();
	initenv();
#ifdef USERSUGG
	initsugg();
#endif
#ifdef SAVEPOS
	initpos();
#endif
#ifdef TYPE_CHECK
	initstc();
#endif
	setprmnv();
	initperm();
}

Visible Procedure endworkspace() {
	endperm();
	endsou();
	endenv();
#ifdef USERSUGG
	endsugg();
#endif
#ifdef SAVEPOS
	endpos();
#endif
#ifdef TYPE_CHECK
	endstc();
#endif
	enderro();
}

/************************************************************************/

Visible bool wsp_writable() {
	return F_writable(CURDIR) ? Yes : No;
}

Hidden Procedure print_wsname() {
	putSstr(errfile, ">%s\n", strval(cur_ws));
	fflush(errfile);
}

/************************************************************************/
