;  This file will translate Function key sequences into those expected by
;  MicroEMACS Version 3.10.  Note that termcap entry definitions will take
;  precedence over this but does not cover all keys.
;
;  Expected character sequence is ^[Ox
;    where the ^[O is bound to this procedure
;          the x is actually a code that identifes the actual key
;            (the strings below give the code/key mappings)

set %olddiscmd $discmd
set $discmd "FALSE"

;                        Note: function key 0 is FN0
set %fkin  "ABCDpqrstuvwxy"  ; => cursor keys,  FN0 ...   FN9
set %fkout "PNFB0123456789"
set %skin  "PQRSmlnM"  ; => S-FN0 ... S-FN9
set %skout "01234567"


store-procedure key-handler-1
;set $debug "TRUE"
    set %olddiscmd $discmd
    set $discmd "TRUE"
    set %oldmode $cmode
;;  add-mode "EXACT"  -- BAD! causes the cursor to move and mode line updated
    set $cmode &bor $cmode 8
    set %key &gtkey	; get lead-in character

    set %keyx &sindex %fkin %key
    !if %keyx
        set %key &cat "FN" &mid %fkout %keyx 1
	!goto done1
    !endif
    set %keyx &sindex %skin %key
    !if %keyx
        set %key &cat "S-FN" &mid %skout %keyx 1
	!goto done1
    !endif
; caractere inconnu
*quit1
	write-message &cat &cat "[Unknown function key: ~"escO" %key "~" ]"
	insert-string &chr 27
	insert-string "O"
	insert-string %key
	set $cmode %oldmode
	set $discmd %olddiscmd
	!return
;
*done1
	done-handler
!endm
;-----------------------------
; handler des sequences esc[[1,2,3][0-9]~ des touches Fi VT220
;      et des sequences esc[<lettre>  (pour terminal facit-twist)       
;
set %akin1  "789"	; F6 F7 F8
set %akout1 "123"	; A-FN 1~3
set %akin2  "0134568"	; F9 F10 F11 F12 F13 F14 F15
set %akout2 "4567890"	; A-FN 4~0
set %ckin2  "9"		; F16
set %ckout2 "0"		; FN^0
set %ckin3  "1234"	; F17 F18 F19 F20
set %ckout3 "1234"	; FN^1~4
;
store-procedure key-handler-2
    set %olddiscmd $discmd
    set $discmd "TRUE"
    set %oldmode $cmode
;;  add-mode "EXACT"  -- BAD! causes the cursor to move and mode line updated
    set $cmode &bor $cmode 8
	set %key2 FALSE
	set %key1 &gtkey	; get lead-in character

	!if &sequal %key1 "1"
		set %key2 &gtkey
		set %keyx &sindex %akin1 %key2
		!if %keyx
			set %key &cat "A-FN" &mid %akout1 %keyx 1
		        !goto done2
		!endif
		!goto quit2
	!endif
	!if &sequal %key1 "2"
		set %key2 &gtkey
		set %keyx &sindex %akin2 %key2 
		!if %keyx
			set %key &cat "A-FN" &mid %akout2 %keyx 1
			!goto done2
		!endif
		set %keyx &sindex %ckin2 %key2
		!if %keyx
			set %key &cat "FN^" &mid %ckout2 %keyx 1
			!goto done2
		!endif
		!goto quit2
	!endif
	!if &sequal %key1 "3"
		set %key2 &gtkey
		set %keyx &sindex %ckin3 %key2
		!if %keyx
			set %key &cat "FN^" &mid %ckout3 %keyx 1
			!goto done2
		!endif
	!endif
; init pour facit-twist (touches du pave curseur)
set %letin 	"VUZXLMPKJABCD"
set %letout	"VUZXLMQKJPNFB"	; FN<lettre>
;
	set %keyx &sindex %letin %key1
	!if %keyx
		set %key &cat "FN" &mid %letout %keyx 1
		done-handler
		!return
	!endif
*quit2
	!if %key2
		set %key1 &cat %key1 %key2
	!endif
	write-message &cat &cat "[Unknown function key: ~"esc[" %key1 "~" ]"
	insert-string &chr 27
	insert-string "["
	insert-string %key1
	set $cmode %oldmode
	set $discmd %olddiscmd
	!return
*done2
	set %lastkey &gtkey
	!if &not &sequal %lastkey "~~"	; VT220 Function keys code end with ~
		set %key2 &cat %key2 %lastkey
		!goto quit2
	!endif
	done-handler
!endm
;-----------------------------
; done-handler - %key contient le nom symbolique de la touche
;
store-procedure done-handler
    set $cmode %oldmode
    set %func &bind %key
    !if &sequal %func "ERROR"
        write-message &cat &cat "[Unbound function key: ~"" %key "~" ]"
    !else
        !if &sequal &left %func 1 "["  ; procedures are in brackets
            set %func &mid %func 2 &sub &length %func 2
            !force execute-procedure %func ; user procedure
        !else
            !force execute-named-command %func ; try for built-in
        !endif
    !endif
    set $discmd %olddiscmd
!endm
;------------------------------------------------------------
; effacement de la ligne complete, <lf ou cr> inclus
;
store-procedure delete-line
	beginning-of-line
	!if &len $line          ; si ligne non vide
		kill-to-end-of-line
	!endif
	kill-to-end-of-line	; destruction du caractere de fin de ligne (cr)
!endm
;
macro-to-key key-handler-1 M-O	; touches pave numerique (application)
macro-to-key key-handler-2 M-[	; touches Fi vt220
;
; bindings supplementaires pour facit-twist
;
bind-to-key	previous-page		FNV	; shift curseur up
bind-to-key	next-page		FNU	; shift curseur down
bind-to-key	beginning-of-line	FNZ	; reverse tab
bind-to-key	end-of-file		FNX	; shift home
bind-to-key	open-line		FNL	; insert line
macro-to-key	delete-line		FNM	; delete line
bind-to-key	delete-next-character	FNQ	; delete char
bind-to-key	kill-to-end-of-line	FNK	; erase
bind-to-key	delete-next-word	FNJ	; shift erase
;
set $discmd %olddiscmd
