; Find-Tags Macro for MicroEMACS 3.8i and higher
; Author: Reimer Mellin
; Modified by: David MacKenzie
; Date: 4 November 1988
;
;
; Here is a modification of Reimar's MicroEMACS tag-finding macro.  I have
; split it up into two front ends; one of them takes the tag from the
; buffer starting at point (the way his does) and the other prompts for it
; on the message line.
; 
; I also renamed some variables to make the code clearer, and made some
; other improvements like respecting the '^' and '$' characters in the
; tags file's regular expressions for more accuracy.
;	David MacKenzie
;	edf@rocky2.rockefeller.edu
;	
; Goes to the tag in a second, bottom window.
; Only allowed in CMODE.

; Searches for the tag of the identifier starting at point.
15	store-macro
	run setup-tags
	!if &not %ok
		!return
	!endif
	set %savecm $cmode
	add-mode "magic"
!force  search-forward "[^0-9A-Za-z_]"	; search for end of identifier
	set $cmode %savecm
	backward-character
	copy-region		; get identifier
	!if &sequal $kill ""
		write-message "No tag specified"
		set $discmd TRUE
		!return
	!endif
	set %ident $kill
	run find-tags
!endm
bind-to-key execute-macro-15 M-T

; Searches for tag of the identifier typed in the message line.
16	store-macro
	run setup-tags
	!if &not %ok
		!return
	!endif
	set %ident @"Search for tag: "
	run find-tags
!endm
bind-to-key execute-macro-16 ^XT

store-procedure setup-tags
	set $discmd FALSE
	!if &not  &band $cmode 2
		write-message "Must be in CMODE"
		set $discmd TRUE
		set %ok FALSE
		!return
	!endif

	set %startcwl $cwline	; remember line
	set-mark
	set %ok TRUE
!endm

store-procedure find-tags
	write-message  &cat  "Searching for tag "  &cat %ident " . . ."

	delete-other-windows
	set %lfrombot  &sub $wline $cwline
	%lfrombot next-line	; go to last line of window
	split-current-window	; so the new window will be the lower one
	previous-window
	; complicated calculation for restoring the old context
	%lfrombot previous-line
	exchange-point-and-mark	; return to original point
	!if &less $wline %startcwl
		set %startcwl $wline
	!endif
	!if &less $cwline %startcwl
		&sub %startcwl $cwline  move-window-up
	!endif

	next-window
	!if &exist "tags"
		find-file "tags"
	!else
		set %errmesg "No tags file"
		previous-window
		!goto error1
	!endif

	; find identifier in tags file
	add-mode "exact"
	add-mode "magic"
	beginning-of-file	; rewind tags file
!force  search-forward  &cat "^"  &cat %ident &chr 9
	!if &not $status
		set %errmesg &cat %ident ": No such tag in tags file"
*error1
!force 		delete-window
*error2
		write-message %errmesg
		set $discmd TRUE
		!return
	!endif

	; extract filename
	set-mark
	search-forward &chr 9	; find tab after filename
	backward-character
	copy-region
	set %tagfile $kill

	; extract search string
	2 forward-character	; skip past tab /
	set-mark
	end-of-line
	backward-character	; back up past /
	copy-region
	set %pattern $kill

!force  find-file %tagfile
	!if &not $status
		set %errmesg  &cat %tagfile " not found"
		!goto error1
	!endif

	; search for pattern in tagfile
	beginning-of-file
	set %savecm $cmode
	add-mode "exact"
	add-mode "magic"
!force  search-forward %pattern
	!if &not $status
		set %errmesg "Pattern for tag not found; rerun ctags"
		!goto error1
	!endif
	set $cmode %savecm

	beginning-of-line	; found the tag
	set-mark

	clear-message-line
	set $discmd TRUE
!endm
