; spell.cmd
;
; semi-interactive MicroEMACS 3.9 spelling checker
; Based on the Unix spell command.
; Activate with M-x run spell-buffer
;
; David MacKenzie
; Latest revision: 08/18/88
;
; 
; In light of the recent spate of spelling checkers, here is one that
; runs under MicroEMACS.  Also, this summer there were discussions about
; automatically uncompressing files from GNU EMACS; this posting also
; contains macros to do that -enhance.cmd-  as well as some other useful extensions.
; The speller depends on the Unix spell program; the other macros
; probably need Unix too.  They have been tested under MicroEMACS3.9e.
; 
; These enclose misspelled words.  Change them if you don't like them.
set %lmark "<<"
set %rmark ">>"

store-procedure spell-buffer

    set %savecbuf $cbufname
    !if &sequal $cfname ""    ; No filename!
        set $cfname $cbufname ; Make one.
    !endif
    set %file $cfname
    save-file               ; Make sure it's up to date.
    update-screen
    
    set %lfile @"Local word list filename (<Return> = none)? "
    !if &or  &sequal %lfile "q"  &sequal %lfile "ERROR" ; Ctrl-G
        write-message "[Spelling correction aborted]"
        !return
    !endif
    !if &not &sequal %lfile ""
        set %lfile &cat  &cat "+" %lfile  " "
    !endif
    
    write-message "[Identifying possible misspellings...]"
    ; run the command with output to the buffer, "command"
    pipe-command &cat  &cat "spell " %lfile  %file
    
    ; "command" is now the selected buffer
    delete-window
    select-buffer %savecbuf
    
    !while "TRUE"
        set %word #command
	!if &sequal %word "ERROR"
	    !break ; No more mis-spelled words.
	!endif

        update-screen
        write-message &cat "Fix `"  &cat %word "' ([y]/n)? "
        set %yn &gtkey
        !if &or  &sequal %yn "q"  &equal &ascii %yn 7 ; Ctrl-G
            write-message "[Spelling correction aborted]"
	    !return
	!endif
	!if &or  &sequal %yn "y"  &sequal %yn " "
            beginning-of-file
            !while "TRUE"
                write-message &cat  &cat "[Searching for `" %word  "'...]"
                !force search-forward %word
                !if &sequal $status "FALSE"
                    !break ; No more matches of this word found.
                !endif
                run mark-word
		update-screen ; Let them see the marked word.
                set %new-word  @&cat  &cat "Replace `" %word  "' with (<Return> to keep)? "

                !if &or  &sequal %new-word "q"  &sequal %new-word "ERROR"
                    run unmark-word
                    write-message "[Spelling correction aborted]"
                    !return
		!endif
                !if &sequal %new-word "n" ; Go on to the next wrong word.
		    run unmark-word
		    !break
		!endif
                !if &sequal %new-word "p" ; Repeat previous correction.
                    set %new-word %old-new
		!endif
                !if &sequal %new-word ""
		    run unmark-word
		!else
                    run replace-word
                !endif
                set %old-new %new-word
		update-screen
            !endwhile
	!endif
    !endwhile
    write-message "[Spelling correction completed]"
!endm

; Mark a word with %lmark and %rmark.
; Assumes point is at the end of the word when called;
; leaves point after %rmark.
store-procedure mark-word
    insert-string %rmark
    set-mark
    previous-word
    insert-string %lmark
!endm

; Remove the mark.
; Assumes point is where mark-word left it, after %lmark.
; Leaves point after the word.
store-procedure unmark-word
    &len %lmark delete-previous-character ; Nuke %lmark.
    exchange-point-and-mark ; Move past %rmark.
    &len %rmark delete-previous-character ; Nuke %rmark
!endm

; Replace the marked word with %new-word.
; Called instead of unmark-word.
; Leaves point after the word.
store-procedure replace-word
    &len %lmark delete-previous-character ; Nuke %lmark.
    kill-region ; Nuke word and %rmark.
    insert-string %new-word
!endm
