; The Towers of Hanoi for the uEMACS 3.9e
; Author: Reimer A. Mellin (ram@altger)
; Date:   6.12.1988
; Implements the recursive algorith. with a buffer :-)
; Well, why shouldn't it work ?
; Just intended as a test version for recursion ....
; Copy, modify, use, abuse this as you like ....

; BTW: dont forget Green-peace and all organizations against famine in
;      the third world.
;
; From irisa!inria!mcvax!unido!altger!ram Thu Dec  8 09:21:38 MET 1988
; Article 2846 of comp.emacs:
; Path: irisa!inria!mcvax!unido!altger!ram
; >From: ram@altger.UUCP (Reimer A. Mellin)
; Subject: Towers of Hanoi for uEMACS 3.9 (and higher)
; Date: 7 Dec 88 01:03:04 GMT
; Organization: Altos Computer Systems Munich
; 
; Hello,
; 
; The uEMACS Macro-language is quite powerful but can't handle recursive
; function-calls (at least in 3.9i).  So here is one way of implementing
; recursive calls....  As a first test I programmed the Towers of Hanoi. 
; Please realize that my version isn't programmed for speed but for
; straightforwardness (mostly :-). 
; 
; You should have the programm 'banner' on your system, because hanoi will
; use it via 'pipe-command' to generate a neat title-page. 
; 
; The numbers of the disks are also restricted to 9, because the pushing
; of the parameters is done with characters.  (someone going to fix this
; ?, maybe pushing of %number as '&chr %number' and reading with '&asc
; %number' ?)
; 
; starting hanoi:
; 	interpret hanoi.cmd with the '-f'-option or with the
; 'execute-buffer'-command.  Then call the procedure hanoi with 'run
; hanoi'.  Hanoi then asks for the number of disks and will display the
; moves. 
; 
; At this point I want to express my thank to Daniel Lawrence for this
; really small, neat, powerful and FREE editor. 
; 
; Greetings
; 	Reimer Mellin
; 
; 
;This procedure pushes the string %pusharg on our stack ....
;i.e. writes at the end of the buffer
store-procedure push
	select-buffer [stack]
	insert-string %pusharg
	newline
!endm

;here we kill our actual context (the previous line in the stack-buffer)
;and re-read our old context !!!
store-procedure pop
	select-buffer [stack]
	previous-line
	kill-to-end-of-line
	run readarg
!endm

; read the current incarnation of our variables on the stack.
store-procedure readarg
	select-buffer [stack]
	set-mark
	previous-line
	exchange-point-and-mark
	copy-region
	set %number &left $kill 1
	set %src &mid $kill 2 1
	set %aux &mid $kill 3 1
	set %dest &mid $kill 4 1
!endm

;just a silly procedure to print our first screen of the towers
store-procedure init-screen
	beginning-of-file
	set-mark
	end-of-file
	kill-region
	set %i 0
	!while &not &equ %i &sub 10 %number
		insert-string &cat %trenner &cat %disk0
		insert-string &cat %trenner &cat %disk0
		insert-string &cat %trenner &cat %disk0
		newline
		set %i &add %i 1
	!endwhile
	set %j 1
	!while &not &equ %i 10
		set %ivar &cat "%disk" %j
		insert-string &cat %trenner &cat &ind %ivar
		insert-string &cat %trenner &cat %disk0
		insert-string &cat %trenner &cat %disk0
		newline
		set %i &add %i 1
		set %j &add %j 1
	!endwhile
	75 insert-string "^"
	update-screen
	set %j @"Press Return to start the fun ..."
!endm

; the various disks and their starting positions on the first screen
store-procedure init-vars
	set %disk9 "#########|#########"
	set %disk8 " ########|######## "
	set %disk7 "  #######|#######  "
	set %disk6 "   ######|######   "
	set %disk5 "    #####|#####    "
	set %disk4 "     ####|####     "
	set %disk3 "      ###|###      "
	set %disk2 "       ##|##       "
	set %disk1 "        #|#        "
	set %disk0 "         |         "
	set %trenner "     "
	set %ynoL %number
	set %ynoM 0
	set %ynoR 0
	set %xnoL 5
	set %xnoM 29
	set %xnoR 53
!endm

;do the move of the uppermost disk on 'src' to 'dest'
store-procedure moveone
	select-buffer [output]
;delete old disk
	beginning-of-file
	set %yvar &cat "%yno" %src
	set %xvar &ind &cat "%xno" %src
	&sub 10 &ind %yvar next-line
	set %old &mid $line %xvar 19
	%xvar forward-character
	19 delete-next-character
	insert-string %disk0
	set &ind %yvar &sub &ind %yvar 1
;insert on new place
	beginning-of-file
	set %yvar &cat "%yno" %dest
	set &ind %yvar &add &ind %yvar 1
	set %xvar &ind &cat "%xno" %dest
	&sub 10 &ind %yvar next-line
	&sub %xvar 1 forward-character
	19 delete-next-character
	insert-string %old
	
	beginning-of-file
	update-screen
!endm

;the trivial recursive hanoi algorithism. push news args before calling an
;new incarnation of 'move'.
store-procedure move
	run readarg	; get new context !!!!
	!if &equ %number 1
		run moveone
		!return
	!endif
	set %pusharg &cat &sub %number 1 &cat %src &cat %dest &cat %aux
	run push
	run move
	run pop
	run moveone
	set %pusharg &cat &sub %number 1 &cat %aux &cat %src &cat %dest
	run push
	run move
	run pop
!endm


;straight forward coding of making the starting window and asking for
;the numbers of disks (with checking). Also handles initialisation and
;destruction of our internal buffers (for recursion and display).
;uses banner to get a neat display (at least on my machine).
; ???? Why can't i use 'unmark-buffer name' ????
store-procedure hanoi
	set %olddiscmd $discmd
	set $discmd FALSE
	delete-other-windows
	set %savebuf $cbufname
	select-buffer [output]
	pipe-command "banner 'Towers of'"
	set %savebuf1 $cbufname
	set-mark
	end-of-file
	copy-region
	next-window
	yank
	delete-other-windows
	delete-buffer %savebuf1
	pipe-command "banner '  Hanoi!'"
	set-mark
	end-of-file
	copy-region
	next-window
	yank
	insert-string "for uEMACS 3.9e (and higher) by Reimer A. Mellin ....."
	delete-other-windows
	delete-buffer %savebuf1
	update-screen
*label1
	set %number @"How may disks on first pole (1-9) ?"
	!if &or  &sgr %number "9" &sle %number "1"
		!goto label1
	!endif
	run init-vars
	run init-screen
; move %numbers disks from Left to Right using Middle
; don't change 'LMR' since the characters are used to construct some
; variables (using '&ind').
	set %pusharg &cat %number "LMR"
	run push
	run move
	select-buffer [stack]
	unmark-buffer
	select-buffer [output]
	set %number @"Finished .... Press Return ....."
	unmark-buffer
	select-buffer %savebuf
	delete-buffer [stack]
	delete-buffer [output]
	set $discmd %olddiscmd
!endm
