;	CPAGE.CMD:	C language MENU Page
;			for MicroEMACS 3.9e and above
;			(C)opyright 1988 by Daniel Lawrence
;

;set $debug TRUE
;---------------------------------
;
store-procedure close-block
set %oldcmd $discmd
set $discmd FALSE
!if %c-mode	; le unbind ne marchant pas, on teste si on est en mode c
	insert-string "{"
	9 set-mark
	set %cline 	$curline
	set %cl1	0
	set %cl2	0
	!force search-reverse "("	; on recherche le mot precedant une (
	!if $status
		!force previous-word
		set %cl1 $curline
		8 set-mark
	!endif
	9 goto-mark
	!force previous-word
	set %cl2	$curline
	!if &equ %cl1 %cline		; une ( dans la ligne courante ?
		8 goto-mark
		!goto found
	!endif
	!if &equ %cl2 %cline		; un mot dans la ligne courante ?
		!goto found
	!endif
	!if &equ %cl1 &sub %cline 1	; une ( ligne precedente ?
		8 goto-mark
		!goto found
	!endif
	!if &equ %cl2 &sub %cline 1	; un mot ligne precedente ?
		!goto found
	!endif
; on n'a rien trouve  => null
	set %inc "block"
	!goto insert
*found
	delete-next-word
	yank
; elimination d'un lf (cr) eventuel dans la mot detruit..
	set %inc $kill
	set %pos &sindex %inc &chr 13	; 13 = cr
	!if %pos
		set %inc &left %inc &sub %pos 1
	!endif
*insert
	9 goto-mark
	newline-and-indent
	insert-string  &cat &cat "} /* end of " &trim %inc " */"
	1 previous-line
	end-of-line
	newline-and-indent
	handle-tab
!else
	insert-string "{"
!endif
set $discmd %oldcmd
!endm
;---------------------------------
store-procedure set-c-mode
	macro-to-key close-block "{"
	set	%c-mode	TRUE
	write-message "c-mode ON"
!endm
;---------------------------------
;
store-procedure unset-c-mode
;	unbind-key }	; quand unbind marchera...
	set	%c-mode	FALSE
	write-message "c-mode OFF"
!endm
;---------------------------------
store-procedure proc
;	set $debug TRUE
        set %proc @"Procedure Name: "
        insert-string &cat &cat "Procedure " %proc "~n"
        insert-string "   ( VAR ~n"
        insert-string "   );~n"
        insert-string "~n"
        insert-string &cat &cat "{ (* " %proc " *)~n"
        insert-string &cat &cat "};  (* " %proc " *)~n"
	previous-line
        open-line
        insert-string "   "
;	set $debug FALSE
!endm

;	Function
store-procedure function
        set %func @"Function Name: "
        set %type @"Return type: "
	insert-string %type
	!if &not &sequal &right %type 1 "*"
		insert-string " "
	!endif                            
        insert-string &cat %func "()~n~n{~n	~n}~n"
        3 backward-character
	!force set $debug FALSE
!endm

;---------
; if else

store-procedure ifelse
        set %cond @"Condition Expr: "
        insert-string &cat &cat "if (" %cond ") {"
	newline-and-indent
	newline-and-indent
        insert-string "} else {"
	newline-and-indent
	newline-and-indent
       	insert-string &cat &cat "}  /* if (" %cond ") */"
	1 previous-line
        end-of-line
        handle-tab
	2 previous-line
        end-of-line
        handle-tab
!endm
;-------
; while
;
store-procedure while
        set %cond @"Condition Expr: "
	;set $debug TRUE
        insert-string &cat &cat "while (" %cond ") {"
	newline-and-indent
	newline-and-indent
        insert-string &cat &cat "}  /* while (" %cond ") */"
	1 previous-line
        end-of-line
	handle-tab
!endm
;-------
; for
;
store-procedure for
        insert-string  "for( ; ; ){"
	newline-and-indent
        insert-string "} /* end of for( ; ; ) */"
	1 previous-line
	end-of-line
	newline-and-indent
	handle-tab
!endm
;-------
; switch
;
store-procedure switch
        set %expr @"Switch Expr: "
        set %curcol $curcol
        insert-string &cat &cat "switch (" %expr ") {"
	newline-and-indent
	insert-string "}"
	previous-line
	end-of-line
	newline-and-indent
	handle-tab
	insert-string "case "
!endm
;------
; comment mismatch?
;
store-procedure	comment
;	start from the current position in the file
	set-mark		; sauve position courante
	set %oldmode $cmode
	!force delete-mode "magic"
	set %cline $curline
	set %cpos  $curcol
	!force search-forward "/*"
	!if &seq $status FALSE			; pas de /*
		!force search-forward "*/"
		!if  $status			; mais un */
			write-message "%%No open1 to this close comment"
		!else
			write-message "%%No more comment"
		!endif
		!goto done
	!endif
	set %nline $curline
	set %npos  $curcol
;	!goto getnext		; y a-t-il un '*/' avant le '/*' trouve?
*getnext
; On verifie qu'il n'y a pas '*/' avant le '/*' trouve
	set $curline %cline	; on retourne au dernier '*/'
	set $curcol  %cpos
	!force search-forward "*/"
	!if $status
		!if &les $curline %nline
			write-message "%%No open3 to this close comment"
			!goto done
		!endif
		!if &and &equ $curline %nline &less $curcol %npos
			write-message "%%No open4 to this close comment"
			!goto done
		!endif
	!endif
	set $curline %nline
	set $curcol  %npos
;	!goto nxtopen 

*nxtopen
	;record the position of the open comment
	update-screen
	set %oline $curline
	set %opos $curcol

	;find the first close comment
	!force search-forward "*/"
	!if &seq $status FALSE
		write-message "%%No close to this open comment"
		!goto done
	!endif

	;record the position of the close comment
	set %cline $curline
	set %cpos $curcol

	;go back to the open and find the next open
	set $curline %oline
	set $curcol %opos

	;and now find the next open
	!force search-forward "/*"
	!if &seq $status FALSE			; pas de /*
		set $curline %cline
		set $curcol  %cpos
		!force search-forward "*/"
		!if $status			; mais un */
			write-message "%%No open2 to this close comment"
		!else
			write-message "%%No error"
		!endif
		!goto done
	!endif
	set %nline $curline
	set %npos $curcol

	;compare the close to the next open
	!if &less %cline %nline
		!goto getnext
	!endif
	!if &and &equ %cline %nline &less %cpos %npos
		!goto getnext
	!endif

	;report a mismatch
	set $curline %oline
	set $curcol %opos
	write-message "%%This comment does not terminate properly"
*done
	update-screen		; pour mise a jour position curseur
	set $cmode %oldmode
	!return

;*getnext
; On verifie qu'il n'y a pas '*/' entre '*/' et '/*'
	set $curline %cline
	set $curcol  %cpos
	!force search-forward "*/"
	!if $status
		!if &les $curline %nline
			write-message "%%No open3 to this close comment"
			!goto done
		!endif
		!if &and &equ $curline %nline &less $curcol %npos
			write-message "%%No open4 to this close comment"
			!goto done
		!endif
	!endif
	set $curline %nline
	set $curcol %npos
	!goto nxtopen 
!endm
macro-to-key comment FN5
;---------------------------
;set $debug FALSE
write-message "[C MENU page loaded]"

