/***************************************************************************
 * This program is Copyright (C) 1986, 1987, 1988 by Jonathan Payne.  JOVE *
 * is provided to you without charge, and with no warranty.  You may give  *
 * away copies of JOVE, including sources, provided that this notice is    *
 * included in all the files.                                              *
 ***************************************************************************/

#if defined(BSD_WAIT)
# include <sys/wait.h>
# define w_termsignum(w)	((w).w_termsig)
/*
** HPUX has the same wait structure as the BSD style wait but it does not
** define WIFSTOPPED, WIFEXITED and WIFSIGNALED the same way as BSD style
** operating system. I can never understand these dual SYSV and BSD OS.
*/
# ifdef HPUX
#  undef WIFSTOPPED
#  undef WIFEXITED
#  undef WIFSIGNALED
#  define WIFSTOPPED(x)   ((x).w_stopval == WSTOPPED)
#  define WIFSIGNALED(x)  ((x).w_stopval != WSTOPPED && (x).w_termsig != 0)
#  define WIFEXITED(x)    ((x).w_stopval != WSTOPPED && (x).w_termsig == 0)
# endif /* HPUX */
#else
# define WIFSTOPPED(w)		(((w).w_status & 0377) == 0177)
# define WIFEXITED(w)		(((w).w_status & 0377) == 0)
# define WIFSIGNALED(w)		((((w).w_status >> 8) & 0377) == 0)
# define w_termsignum(w)	((w).w_status & 0177)
# define wait2(w, x)		wait(w)

union wait {
	int	w_status;
};
#endif

extern void
	kill_off proto((int, union wait));
