static	char	*dlog_c = "$Header: RCS/dlog.c,v 1.9 91/11/11 19:31:43 mer Exp $";

#include "utils/log.h"
#include "support/master.h"

extern int	Debugfile, Ttyfile, Dblog, Slog;
extern short	DebugLvl;	/* set by -d option */

/*
 * debug and error logger
 */

int	Cline;
char	*Cfile;

dlog(lvl, mess)
long	lvl;
char	*mess;
{
	char	line[256], *ctime();
	long	time(), ct;
	int	len;

	if ((lvl & 0xff) < DebugLvl)
	  return;
	line[0] = '\0';
	if (lvl & PTIME) {
		/* put time into buffer */
		time(&ct);
		strcpy(line, ctime(&ct)+4);
		line[16] = '\0';
	}
	if (lvl & POS)
	  strcat(line, form((int) "File %s, line %d:", Cfile, Cline));
	strcat(line, mess);
	strcat(line, "\n");
	len = strlen(line);
	if (Debugfile >= 0)
	  write(Debugfile, line, len);
	if ((lvl & TERM) && Ttyfile >= 0)
	  write(Ttyfile, line, len);
	if ((lvl & DBLOG) && Dblog >= 0)
	  write(Dblog, line, len);
	if ((lvl & SLOG) && Slog >= 0)
	  write(Slog, line, len);
	if (lvl & ABORT)
	  abort();
}
