/* ----------------------------------------------------------------
 *	syms.h
 *
 *	macros defining dynamic symbols for the function manager
 *
 *	Note: this file exists only to clean up proliferation
 *	      of definitions in other .h files.  This information
 *	      should be put elsewhere, once a good solution is
 *	      thought out.. *THIS IS A HACK*  -cim 10/5/89
 *
 *	$Header: RCS/syms.h,v 1.11 91/05/01 02:50:31 cimarron Exp $
 * ----------------------------------------------------------------
 */

#ifndef SymsHIncluded
#define SymsHIncluded 1		/* only include this once */

#define C_SYMBOLS \
	SymbolDecl(ExceptionalCondition), \
	SymbolDecl(form)

#define BUF_SYMBOLS \
	SymbolDecl(RelationGetNumberOfBlocks), \
	SymbolDecl(BufferIsValid), \
	SymbolDecl(BufferIsInvalid), \
	SymbolDecl(BufferIsUnknown)

#define BUFMGR_SYMBOLS \
	SymbolDecl(BufferGetBlock), \
	SymbolDecl(BufferGetRelation), \
	SymbolDecl(BufferGetBlockSize), \
	SymbolDecl(BufferGetBlockNumber), \
	SymbolDecl(ReadBuffer), \
	SymbolDecl(WriteBuffer), \
	SymbolDecl(WriteNoReleaseBuffer), \
	SymbolDecl(ReleaseBuffer), \
	SymbolDecl(BufferWriteInOrder)

/*
 * Protected symbols:
 *
 *	RelationGetBuffer
 *	BufferPut
 */


#define BUFPAGE_SYMBOLS \
	SymbolDecl(BufferGetPage), \
	SymbolDecl(BufferGetPageSize), \
	SymbolDecl(PageInit), \
	SymbolDecl(PageGetMaxOffsetIndex), \
	SymbolDecl(PageGetItem), \
	SymbolDecl(PageAddItem), \
	SymbolDecl(PageRemoveItem), \
	SymbolDecl(PageRepairFragmentation), \
	SymbolDecl(PageGetFreeSpace), \
	SymbolDecl(PageManagerModeSet)

#define CATNAME_SYMBOLS \
	ExternDecl(AggregateRelationName), \
	ExternDecl(AccessMethodRelationName), \
	ExternDecl(AccessMethodOperatorRelationName), \
	ExternDecl(AttributeRelationName), \
	ExternDecl(DatabaseRelationName), \
	ExternDecl(DefaultsRelationName), \
	ExternDecl(DemonRelationName), \
	ExternDecl(IndexRelationName), \
	ExternDecl(InheritProcedureRelationName), \
	ExternDecl(InheritsRelationName), \
	ExternDecl(InheritancePrecidenceListRelationName), \
	ExternDecl(LanguageRelationName), \
	ExternDecl(LogRelationName), \
	ExternDecl(MagicRelationName), \
	ExternDecl(OperatorClassRelationName), \
	ExternDecl(OperatorRelationName), \
	ExternDecl(ProcedureArgumentRelationName), \
	ExternDecl(ProcedureRelationName), \
	ExternDecl(Prs2RuleRelationName), \
	ExternDecl(Prs2PlansRelationName), \
	ExternDecl(Prs2StubRelationName), \
	ExternDecl(RelationRelationName), \
	ExternDecl(ServerRelationName), \
	ExternDecl(StatisticRelationName), \
	ExternDecl(TimeRelationName), \
	ExternDecl(TypeRelationName), \
	ExternDecl(UserRelationName), \
	ExternDecl(VariableRelationName), \
	ExternDecl(VersionRelationName), \
	SymbolDecl(NameIsSystemRelationName), \
	SymbolDecl(NameIsSharedSystemRelationName)

#define COMMAND_SYMBOLS \
	SymbolDecl(CreateQueryDesc), \
	SymbolDecl(ProcessQuery), \
	SymbolDecl(ProcessUtility), \
	SymbolDecl(PerformPortalFetch), \
	SymbolDecl(PerformPortalClose), \
	SymbolDecl(PerformRelationFilter)
/*
 * Protected symbols:
 *
 *	EndCommand
 *	PortalCleanup
 */

#define EXC_SYMBOLS \
	ExternDecl(ExcCurFrameP), \
	SymbolDecl(EnableExceptionHandling), \
	SymbolDecl(ExcRaise)
/*
 * Protected symbols:
 *
 *	ExcGetUnCaught
 *	ExcSetUnCaught
 *	ExcPrint
 *
 * What about ProgramName?  Unclear at first glance to me.  -hirohama
 */

#define EXCID_SYMBOLS \
	ExternDecl(FailedAssertion), \
	ExternDecl(BadState), \
	ExternDecl(BadArg), \
	ExternDecl(BadAllocSize), \
	ExternDecl(ExhaustedMemory), \
	ExternDecl(Unimplemented)
/*
 * Private symbols:
 *
 *	CatalogFailure
 *	InternalError
 *	SemanticError
 *	SystemError
 */

#define FD_SYMBOLS \
	SymbolDecl(FileNameOpenFile), \
	SymbolDecl(FileClose), \
	SymbolDecl(FileRead), \
	SymbolDecl(FileWrite), \
	SymbolDecl(FileSeek), \
	SymbolDecl(FileTell), \
	SymbolDecl(FileSync), \
	SymbolDecl(AllocateFile), \
	SymbolDecl(AllocateFiles), \
	SymbolDecl(FreeFile), \
	SymbolDecl(FreeFiles)


#define FOOBARTE_SYMBOLS \
	ExternDecl(Foo1), \
	SymbolDecl(Bar1), \
	SymbolDecl(Last)
/*
 * Protected symbols:
 *
 *	Die9
 */

#define GLOBALS_SYMBOLS \
	ExternDecl(MyDatabaseName), \
	ExternDecl(MyDatabaseId), \
	ExternDecl(IsUnderPostmaster)
/*
 * Protected symbols:
 *
 *	Debugfile
 *	Ttyfile
 *	Dblog
 *	Slog
 *	Portfd
 *	Packfd
 *	Slog
 *	Pipefd
 *	Noversion
 *	MyBackendId
 *	MyBackendTag
 *	MyDatabaseNameData
 *	MyDatabaseIdIsInitialized
 *	TransactionInitWasProcessed
 *	Ident
 */

/*
 * Protected symbols:
 *
 *	StrategyNumberIsInBounds
 *	AttributeNumberGetIndexStrategySize
 *	StrategyMapIsValid
 *	StrategyMapGetScanKeyEntry
 *	IndexStrategyGetStrategyMap
 *	AttributeNumberGetIndexStrategySize
 *	IndexStrategyInintialize
 */

#define ITEMPTR_SYMBOLS \
	SymbolDecl(ItemPointerEquals), \
	SymbolDecl(ItemPointerGetLogicalPageNumber), \
	SymbolDecl(ItemPointerSetLogicalPageNumber)

#define NAME_SYMBOLS \
	SymbolDecl(NameIsEqual), \
	SymbolDecl(NameComputeLength)

#ifndef PALLOC_DEBUG
#define PALLOC_SYMBOLS \
	SymbolDecl(palloc), \
	SymbolDecl(pfree), \
	SymbolDecl(repalloc)
#else
#define PALLOC_SYMBOLS \
	SymbolDecl(palloc_debug), \
	SymbolDecl(pfree_debug), \
	SymbolDecl(repalloc)
#endif PALLOC_DEBUG

#define PART_SYMBOLS \
	SymbolDecl(CreatePagePartition), \
	SymbolDecl(PagePartitionGetPagesPerBlock)

#define PMOD_SYMBOLS \
	SymbolDecl(IsNoProcessingMode), \
	SymbolDecl(IsBootstrapProcessingMode), \
	SymbolDecl(IsInitProcessingMode), \
	SymbolDecl(IsNormalProcessingMode)

#define PORTAL_SYMBOLS \
	SymbolDecl(EnablePortalManager), \
	SymbolDecl(PortalIsValid), \
	SymbolDecl(GetPortalByName), \
	SymbolDecl(BlankPortalAssignName), \
	SymbolDecl(PortalSetQuery), \
	SymbolDecl(PortalGetQueryDesc), \
	SymbolDecl(PortalGetState), \
	SymbolDecl(PortalDestroy), \
	SymbolDecl(PortalResetHeapMemory), \
	SymbolDecl(StartPortalAllocMode), \
	SymbolDecl(EndPortalAllocMode), \
	SymbolDecl(PortalGetVariableMemory), \
	SymbolDecl(PortalGetHeapMemory), \
	SymbolDecl(PortalVariableMemoryGetPortal), \
	SymbolDecl(PortalHeapMemoryGetPortal), \
	SymbolDecl(PortalVariableMemoryGetHeapMemory), \
	SymbolDecl(PortalHeapMemoryGetVariableMemory)
/*
 * Protected symbols:
 *
 *	CreatePortal
 */

#define REL_SYMBOLS \
	SymbolDecl(RelationGetSystemPort), \
	SymbolDecl(RelationGetAccessMethodTupleForm), \
	SymbolDecl(RelationGetRelationTupleForm), \
	SymbolDecl(RelationGetTupleDescriptor), \
	SymbolDecl(RelationGetIndexStrategy), \
	SymbolDecl(RelationGetRelationId), \
	SymbolDecl(RelationGetFile), \
	SymbolDecl(RelationGetRelationName), \
	SymbolDecl(RelationGetNumberOfAttributes)
/*
 *	SymbolDecl(RelationHasReferenceCountZero)
 *	SymbolDecl(RelationIncrementReferenceCount)
 *	SymbolDecl(RelationDecrementReferenceCount)
 *	SymbolDecl(RelationSetIndexStrategy)
 */

#define RLOCK_SYMBOLS \
	SymbolDecl(RuleLockIntermediateToInternal), \
	SymbolDecl(RuleLockInternalToIntermediate), \
	SymbolDecl(RuleLockIntermediateSort), \
	SymbolDecl(RuleLockIntermediateCopy), \
	SymbolDecl(RuleLockIntermediateFree), \
	SymbolDecl(RuleLockIntermediateRemove), \
	SymbolDecl(RuleLockIntermediatePrint), \
	SymbolDecl(RuleLockIntermediateRemoveEarlyWrite), \
	SymbolDecl(RuleLockIntermediateCopyEarlyWriteLocks)
/*
 * Protected symbols:
 *
 *	RuleLockIntermediateSingleLockUnion
 *	RuleLockIntermediateDump
 *	RuleLockIntermediateFindEWLock
 *	RuleLockIntermediateRelationLock
 *	RuleLockIntermediateSetDirection
 *	RuleLockIntermediateUnion
 */

#define SKEY_SYMBOLS \
	SymbolDecl(ScanKeyEntrySetIllegal), \
	SymbolDecl(ScanKeyEntryInitialize)


#define TIM_SYMBOLS \
	SymbolDecl(AbsoluteTimeIsBefore)

#define TQUAL_SYMBOLS \
	ExternDecl(SelfTimeQual), \
	SymbolDecl(TimeQualIsValid), \
	SymbolDecl(TimeQualIsLegal), \
	SymbolDecl(TimeQualIncludesNow), \
	SymbolDecl(TimeQualIncludesPast), \
	SymbolDecl(TimeQualIsSnapshot), \
	SymbolDecl(TimeQualIsRanged), \
	SymbolDecl(TimeQualIndicatesDisableValidityChecking), \
	SymbolDecl(TimeQualGetSnapshotTime), \
	SymbolDecl(TimeQualGetStartTime), \
	SymbolDecl(TimeQualGetEndTime), \
	SymbolDecl(TimeFormSnapshotTimeQual), \
	SymbolDecl(TimeFormRangedTimeQual), \
	SymbolDecl(HeapTupleSatisfiesTimeQual)

#define TUPDESC_SYMBOLS \
	SymbolDecl(CreateTemplateTupleDesc), \
        SymbolDecl(TupleDescInitEntry)

#define XID_SYMBOLS \
	ExternDecl(NullTransactionId), \
	SymbolDecl(TransactionIdIsValid), \
	SymbolDecl(StringFormTransactionId), \
	SymbolDecl(TransactionIdStore), \
	SymbolDecl(PointerStoreInvalidTransactionId), \
	SymbolDecl(TransactionIdEquals), \
	SymbolDecl(TransactionIdIsLessThan)

#endif SymsHIncluded
