/* ----------------------------------------------------------------
 *   FILE
 *     	name.h
 *
 *   DESCRIPTION
 *     	definition of the catalog/system "name" data type.
 *	This is used by some of the access method and catalog
 *	support code.
 *
 *   NOTES
 *	Since "name" derives directly from a system type, this
 *	stuff should arguably go in postgres.h
 *
 *   IDENTIFICATION
 *   	$Header: RCS/name.h,v 1.11 91/11/10 20:46:47 clarsen Exp $
 * ----------------------------------------------------------------
 */
#ifndef NameIncluded		/* Include this file only once */
#define	NameIncluded	1

#include "tmp/postgres.h"

/* ----------------
 *	definition of NameData and Name
 *	Note: char16 is a system type in postgres.h
 * ----------------
 */
typedef char16		NameData;
typedef NameData	*Name;

/* ----------------
 *	Name support stuff.
 * ----------------
 */
#define InvalidName	((Name) NULL)


/*
 * NameIsEqual
 *	True iff the names are the same.
 */
extern
bool
NameIsEqual ARGS((
	Name	name1,
	Name	name2
));

/*
 * NameComputeLength
 *	Returns the lenght of a name.
 */
uint32
NameComputeLength ARGS((
	Name	name
));

#endif	/* !defined(NameIncluded) */
