/*
 * kwlist.h --
 *	Declarations for KeywordList type.
 *
 * Identification:
 *	$Header: RCS/kwlist.h,v 1.4 91/05/22 14:01:31 kemnitz Exp $
 */

#ifndef KWListIncluded
#define KWListIncluded

#ifdef NOTDEF

#include "access/kw.h"

/*
 * KeywordList class definitions.
 */
typedef	struct KeywordListData {
	int32		nkw;
	KeywordData	kw[1];	/* VARIABLE-LENGTH STRUCTURE */
} KeywordListData;
typedef	KeywordListData		*KeywordList;


/*
 * Interface procedure definitions.
 */

extern KeywordList	kwlist_in();
extern char		*kwlist_out();

extern KeywordList	kw_in();
extern char		*kw_out();

extern KeywordList	kwlist_extract();
extern int32		kwlist_count();
extern Keyword		kwlist_element();
extern KeywordList	kwlist_listify();

extern float64		kwlistsel();
extern float64		kwlistnpages();


/*
 * Internal macro definitions.
 */

#define	KeywordListSize(n) \
((unsigned) (sizeof(int32) + (n) * sizeof(KeywordData)))

#define	KeywordListGetKeyword(kwl, n)		(&(kwl)->kw[(n)])
#define	KeywordListGetKeywordCount(kwl)		((kwl)->nkw)

#define	KeywordListSetKeyword(kwl, n, kw) \
strncpy((char *) KeywordListGetKeyword((kwl), (n)), \
	(char *) (kw), \
	sizeof(KeywordData))
#define	KeywordListSetKeywordCount(kwl, n)	(kwl)->nkw = (n)

#define	InvalidKeywordList	((KeywordList) NULL)
#define	KeywordListIsValid(kwl)	((kwl) != InvalidKeywordList)

#endif
#endif /* !KWListIncluded */
