#------------
#
# default compilation rules
# - conversion rules for the few targets that
#   are common to almost all makefiles
# - needs the variables 
#   CFLAGS, DFLAGS
#   to be correctly set in the main-body makefile {postgres,support}.mk
#
# $Header: RCS/defaults.mk,v 1.10 91/05/14 14:31:23 kemnitz Exp $
#
#
# NOTE:  For portability reasons, the BSD construction 
# "$(*<F)"
# has been replaced by
# `basename $(<F)`
# which is functionally equivalent.
#
#------------

.y.o:
	@- echo yaccing $(<F) ; \
	trap 'rm -f yacc.acts yacc.tmp y.tab.c y.output y.tab.h `basename $(<F)`.c `basename $(<F)`.h; exit' 2 ; \
	cd $(@D) ; yacc -dv $(<F) ; \
	if [ -f yacc.sed ] ; then \
		echo "sed'ing y.tab.c" ; \
		sed -f yacc.sed < y.tab.c > `basename $(<F) .y`.c ;\
	else \
	 	mv y.tab.c `basename $(<F) .y`.c ; \
	fi ; \
	$(CC) $(CFLAGS) $(DFLAGS) -c `basename $(<F) .y`.c ;\
	rm -f `basename $(<F)`.c
	
.c.o:
	@ echo compiling $< | /bin/sed -e 's:$(OD)/::' ; \
	cd $(@D) ; $(CC) $(CFLAGS) $(DFLAGS) -c $(<F)
	
.lex.o:
	@- echo lexing $(<F) ; \
	trap 'rm -f lex.yy.c `basename $(<F)`.c' 2 ; \
	cd $(@D) ; lex $(<F) ; \
	if [ -f lex.sed ] ; then \
		echo "sed'ing lex.yy.c" ; \
		/bin/sed -f lex.sed < lex.yy.c > `basename $(<F) .lex`.c; \
	else \
		mv lex.yy.c `basename $(<F) .lex`.c ; \
	fi ; \
	$(CC) $(CFLAGS) $(DFLAGS) -c `basename $(<F) .lex`.c ; \
	rm -f `basename $(<F) .lex`.c 
	
