/*
 * bufpage/internal.h --
 *	Internal definitions.
 *
 * renamed to internal_page.h as there is already an internal.h in this dir.
 *
 * Identification:
 *	$Header: /usr/local/devel/postgres/src/backend/storage/page/RCS/internal_page.h,v 1.4 1990/09/25 16:46:03 kemnitz Exp $
 */

#ifndef	InternalDefined
#define	InternalDefined	1

#include "storage/bufpage.h"

#define MaxInternalFragmentation	((1 << 12) - 1)
typedef struct OpaqueData {
	bits16	pageSize:4,		/* page size */
		fragmentation:12;	/* internal fragmentation */
} OpaqueData;

typedef OpaqueData	*Opaque;

/*
 * OpaqueGetPageSize --
 *	Returns the page size.
 */
extern
PageSize
OpaqueGetPageSize ARGS((
	Opaque	opaque
));

/*
 * OpaqueSetPageSize --
 *	Sets the page size.
 */
extern
void
OpaqueSetPageSize ARGS((
	Opaque	*opaqueInOutP,
	PageSize	pageSize
));

/*
 * OpaqueGetInternalFragmentation --
 *	Returns the internal fragmentation.
 */
extern
InternalFragmentation
OpaqueGetInternalFragmentation ARGS((
	Opaque	opaque
));

/*
 * OpaqueSetInternalFragmentation --
 *	Sets the internal fragmentation.
 */
extern
void
OpaqueSetInternalFragmentation ARGS((
	Opaque	opaque
));

#endif	/* !defined(InternalDefined) */
