
/*     
 *      FILE
 *     	internal
 *     
 *      DESCRIPTION
 *     	Definitions required throughout the query optimizer.
 *     
 */
/* RcsId ("$Header: /usr/local/devel/postgres/src/backend/planner/util/RCS/internal.c,v 1.16 1992/08/10 21:46:25 mer Exp $"); */

/*     
 */

/*    
 *    	---------- SHARED MACROS
 *    
 *     	Macros common to modules for creating, accessing, and modifying
 *    	query tree and query plan components.
 *    	Shared with the executor.
 *    
 */

#include "planner/internal.h"
#include "nodes/relation.h"
#include "nodes/plannodes.h"
#include "nodes/primnodes.h"
#include "utils/log.h"

/*    
 *    	---------- GLOBAL VARIABLES
 *    
 *    	These *should* disappear eventually...shouldn't they?
 *    
 */

/* from the parse tree: */

LispValue _query_result_relation_;
					/*   relid of the result relation */
int  _query_command_type_ = 0;    /*   command type as a symbol */
int  _query_max_level_ = 0;      /*   max query nesting level */
LispValue  _query_range_table_;     /*   relations to be scanned */

/*     internal to planner:  */
List _base_relation_list_;    /*   base relation list */
List _join_relation_list_;  /* list of relations generated by joins */
bool _query_is_archival_;       /*   archival query flag */


/* (defmacro with_saved_globals (&rest,body)  XXX fix me */

typedef struct {
    LispValue qrr;
    int       qct;
    int       qml;
    LispValue qrt;
    LispValue brl;
    LispValue jrl;
    int       qia;
} planner_globals_hack;

char *
save_globals ()
{
    planner_globals_hack *pghP;

    pghP = (planner_globals_hack *)palloc(sizeof(planner_globals_hack));
    pghP->qrr = _query_result_relation_;
    pghP->qct =	_query_command_type_;
    pghP->qml = _query_max_level_;
    pghP->qrt = _query_range_table_;
    pghP->brl = _base_relation_list_;
    pghP->jrl = _join_relation_list_;
    pghP->qia = _query_is_archival_;
    return (char *)pghP;
}

void
restore_globals(pgh)
    char *pgh;
{
    planner_globals_hack *pghP = (planner_globals_hack *)pgh;

    _query_result_relation_ = pghP->qrr;
    _query_command_type_   = pghP->qct;
    _query_max_level_ = pghP->qml;
    _query_range_table_ = pghP->qrt;
    _base_relation_list_ = pghP->brl;
    _join_relation_list_ = pghP->jrl;
    _query_is_archival_ = pghP->qia;
    pfree(pgh);
    return;
}

List
joinmethod_clauses(method)
     JoinMethod method;
{
  return(method->clauses);
}

List
joinmethod_keys(method)
     JoinMethod method;
{
    return(method->jmkeys);
}
     
/* XXX - these should go away once spyros turns in some code */

Node
rule_lock_plan()
{
    return((Node)NULL);
}

Node 
make_rule_lock()
{
    return((Node)NULL);
}

Node
rule_lock_type()
{
    return((Node)NULL);
}

Node 
rule_lock_attribute()
{
    return((Node)NULL);
}

Node
rule_lock_relation()
{
    return((Node)NULL);
}

Node
rule_lock_var()
{
    return((Node)NULL);
}

int _rule_lock_type_alist_ = 0;
int _rule_type_alist_ = 0;

TLE
MakeTLE(foo,bar)
     Resdom foo;
     Expr bar;
{
    return(lispCons((LispValue)foo,lispCons((LispValue)bar,LispNil)));
}

void
set_joinlist(foo,bar)
     TL foo;
     List bar;
{
    CDR(foo) = bar;
}

Var
get_expr (foo)
     TLE foo;
{
    Assert(!null(foo));
    Assert(!null(CDR(foo)));
    /* Assert(IsA(foo,LispValue)); */
    return((Var)CADR(foo));
}

Resdom
get_resdom (foo)
     TLE foo;
{
    /* Assert(IsA(foo,LispValue)); */
    return((Resdom)CAR(foo));
}

TLE
get_entry(foo)
     TL foo;
{
    /* Assert(IsA(foo,LispValue)); */

    return(CAR(foo));
}
void
set_entry(node,foo)
     TL node;
     TLE foo;
{
    CAR(node) = foo;
}

List
get_joinlist(foo)
     TL foo;
{
    /* Assert(IsA(foo,LispValue)); */

    return (CDR(foo));
}

void
init_planner()
{
    _query_result_relation_ = LispNil;
    _query_command_type_ = 0;
    _query_max_level_ = 1;
    _query_range_table_ = LispNil;
    _base_relation_list_ = LispNil;
    _join_relation_list_ = LispNil;
    _query_is_archival_ = false;
}
